/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.catalog;

import java.math.BigDecimal;
import org.ferris.astronomy.data.catalog.Catalog;
import org.ferris.astronomy.data.linelist.LineList;
import org.ferris.astronomy.data.linelist.LineListFactory;
import org.ferris.lang.string.ToStringStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogBean
implements Catalog {
    private static final long serialVersionUID = 12308940258624756L;
    private String molecule;
    private double calculatedFrequency;
    private String calculatedFrequencyString;
    private BigDecimal calculatedFrequencyError;
    private String measuredFrequencyString;
    private BigDecimal measuredFrequency;
    private BigDecimal measuredFrequencyError;
    private BigDecimal energyLevel;
    private String quantumNumbers;
    private BigDecimal jUp;
    private BigDecimal KaUp;
    private BigDecimal KcUp;
    private BigDecimal jLow;
    private BigDecimal KaLow;
    private BigDecimal KcLow;
    private BigDecimal relativeIntensity;
    private BigDecimal lineStrength;
    private String reference;
    private LineList lineList;
    private ToStringStrategy<Catalog> toStringStrategy = new ToStringStrategy<Catalog>(){
        private static final long serialVersionUID = 5627062301098855924L;

        public String toString(Catalog cat) {
            StringBuffer sp = new StringBuffer();
            sp.append("[CatalogBean");
            sp.append(" molecule=").append(cat.getMolecule());
            sp.append(", frequency=").append(cat.getFrequency());
            sp.append("]");
            return sp.toString();
        }
    };
    private String moleculeName;

    protected CatalogBean setEnergyLevel(BigDecimal energyLevel) {
        this.energyLevel = energyLevel;
        return this;
    }

    protected CatalogBean setCalculatedFrequency(double frequency) {
        this.calculatedFrequency = frequency;
        return this;
    }

    protected CatalogBean setCalculatedFrequencyError(BigDecimal frequencyError) {
        this.calculatedFrequencyError = frequencyError;
        return this;
    }

    protected CatalogBean setJLow(BigDecimal low) {
        this.jLow = low;
        return this;
    }

    protected CatalogBean setJUp(BigDecimal up) {
        this.jUp = up;
        return this;
    }

    protected CatalogBean setKaLow(BigDecimal kaLow) {
        this.KaLow = kaLow;
        return this;
    }

    protected CatalogBean setKaUp(BigDecimal kaUp) {
        this.KaUp = kaUp;
        return this;
    }

    protected CatalogBean setKcLow(BigDecimal kcLow) {
        this.KcLow = kcLow;
        return this;
    }

    protected CatalogBean setKcUp(BigDecimal kcUp) {
        this.KcUp = kcUp;
        return this;
    }

    protected CatalogBean setLineStrength(BigDecimal lineStrength) {
        this.lineStrength = lineStrength;
        return this;
    }

    protected CatalogBean setMeasuredFrequency(BigDecimal measuredFrequency) {
        this.measuredFrequency = measuredFrequency;
        return this;
    }

    protected CatalogBean setMeasuredFrequencyError(BigDecimal measuredFrequencyError) {
        this.measuredFrequencyError = measuredFrequencyError;
        return this;
    }

    protected CatalogBean setMolecule(String molecule) {
        this.molecule = molecule;
        return this;
    }

    protected CatalogBean setQuantumNumbers(String quantumNumbers) {
        this.quantumNumbers = quantumNumbers;
        return this;
    }

    protected CatalogBean setReference(String reference) {
        this.reference = reference;
        return this;
    }

    protected CatalogBean setRelativeIntensity(BigDecimal relativeIntensity) {
        this.relativeIntensity = relativeIntensity;
        return this;
    }

    protected CatalogBean setCalculatedFrequencyString(String calculatedFrequencyString) {
        this.calculatedFrequencyString = calculatedFrequencyString;
        return this;
    }

    protected CatalogBean setMeasuredFrequencyString(String measuredFrequencyString) {
        this.measuredFrequencyString = measuredFrequencyString;
        return this;
    }

    protected CatalogBean setLineList(String name) {
        this.lineList = LineListFactory.getLineList(name, name);
        return this;
    }

    protected CatalogBean setMoleculeName(String moleculeName) {
        this.moleculeName = moleculeName;
        return this;
    }

    protected CatalogBean() {
    }

    @Override
    public BigDecimal getEnergyLevel() {
        return this.energyLevel;
    }

    @Override
    public double getFrequency() {
        return this.getCalculatedFrequency();
    }

    @Override
    public double getCalculatedFrequency() {
        return this.calculatedFrequency;
    }

    @Override
    public BigDecimal getCalculatedFrequencyError() {
        return this.calculatedFrequencyError;
    }

    @Override
    public BigDecimal getJLow() {
        return this.jLow;
    }

    @Override
    public BigDecimal getJUp() {
        return this.jUp;
    }

    @Override
    public BigDecimal getKaLow() {
        return this.KaLow;
    }

    @Override
    public BigDecimal getKaUp() {
        return this.KaUp;
    }

    @Override
    public BigDecimal getKcLow() {
        return this.KcLow;
    }

    @Override
    public BigDecimal getKcUp() {
        return this.KcUp;
    }

    @Override
    public BigDecimal getLineStrength() {
        return this.lineStrength;
    }

    @Override
    public BigDecimal getMeasuredFrequency() {
        return this.measuredFrequency;
    }

    @Override
    public BigDecimal getMeasuredFrequencyError() {
        return this.measuredFrequencyError;
    }

    @Override
    public String getMolecule() {
        return this.molecule;
    }

    @Override
    public String getQuantumNumbers() {
        return this.quantumNumbers;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public BigDecimal getRelativeIntensity() {
        return this.relativeIntensity;
    }

    @Override
    public String getCalculatedFrequencyString() {
        return this.calculatedFrequencyString;
    }

    @Override
    public String getMeasuredFrequencyString() {
        return this.measuredFrequencyString;
    }

    @Override
    public LineList getLineList() {
        return this.lineList;
    }

    public String toString() {
        return this.toStringStrategy == null ? super.toString() : this.toStringStrategy.toString((Object)this);
    }

    @Override
    public void setToStringStrategy(ToStringStrategy<Catalog> toStringStrategy) {
        this.toStringStrategy = toStringStrategy;
    }

    @Override
    public ToStringStrategy<Catalog> getToStringStrategy() {
        return this.toStringStrategy;
    }

    @Override
    public String getMoleculeName() {
        return this.moleculeName;
    }
}

