/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.catalog;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.catalog.Catalog;
import org.ferris.astronomy.data.catalog.CatalogBean;
import org.ferris.astronomy.data.catalog.CatalogFactoryDefault;
import org.ferris.astronomy.data.slaim.CalculatedFrequencyParser;
import org.ferris.astronomy.data.slaim.EnergyLevelParser;
import org.ferris.astronomy.data.slaim.LineStrengthParser;
import org.ferris.astronomy.data.slaim.LineToParse;
import org.ferris.astronomy.data.slaim.MeasuredFrequencyParser;
import org.ferris.astronomy.data.slaim.MoleculeNameParser;
import org.ferris.astronomy.data.slaim.QuantumNumbersParser;
import org.ferris.astronomy.data.slaim.ReferenceParser;
import org.ferris.astronomy.data.slaim.RelativeIntensityParser;
import org.ferris.astronomy.util.split.StringSplitterDecorator;
import org.ferris.sql.ResultSetTools;

public abstract class CatalogFactory {
    private static Logger log = Logger.getLogger(CatalogFactory.class);
    private static CatalogFactory instance = null;

    private static CatalogFactory getInstance() {
        if (instance == null) {
            log.info((Object)"Determine CatalogFactory instance");
            String fullyQualifiedClassName = System.getProperty("org.ferris.astronomy.data.catalog.CatalogFactory");
            log.info((Object)("fullyQualifiedClassName: " + fullyQualifiedClassName));
            if (fullyQualifiedClassName == null) {
                instance = new CatalogFactoryDefault();
            } else {
                try {
                    Object o = Class.forName(fullyQualifiedClassName).newInstance();
                    if (CatalogFactory.class.isAssignableFrom(o.getClass())) {
                        instance = (CatalogFactory)o;
                        log.info((Object)("Created instance: " + fullyQualifiedClassName));
                    }
                }
                catch (Throwable t) {
                    log.warn((Object)("The class name \"" + fullyQualifiedClassName + "\" is not found in the class path."), t);
                }
                if (instance == null) {
                    instance = new CatalogFactoryDefault();
                }
            }
        }
        return instance;
    }

    public static Catalog getCatalog(String molecule, String calculated_freq_asString, double calculated_freq, BigDecimal calculated_freq_err, String measured_freq_asString, BigDecimal measured_freq, BigDecimal measured_freq_err, BigDecimal energy_level, String quantum_number, BigDecimal j_up, BigDecimal ka_up, BigDecimal kc_up, BigDecimal j_low, BigDecimal ka_low, BigDecimal kc_low, BigDecimal relative_intensity_hfs, BigDecimal line_strength_sij, String slaim_ref, String moleculeName, String lineList) {
        return CatalogFactory.getInstance().getCatalogInstance(molecule, calculated_freq_asString, calculated_freq, calculated_freq_err, measured_freq_asString, measured_freq, measured_freq_err, energy_level, quantum_number, j_up, ka_up, kc_up, j_low, ka_low, kc_low, relative_intensity_hfs, line_strength_sij, slaim_ref, moleculeName, lineList);
    }

    protected Catalog getCatalogInstance(String molecule, String calculated_freq_asString, double calculated_freq, BigDecimal calculated_freq_err, String measured_freq_asString, BigDecimal measured_freq, BigDecimal measured_freq_err, BigDecimal energy_level, String quantum_number, BigDecimal j_up, BigDecimal ka_up, BigDecimal kc_up, BigDecimal j_low, BigDecimal ka_low, BigDecimal kc_low, BigDecimal relative_intensity_hfs, BigDecimal line_strength_sij, String slaim_ref, String moleculeName, String lineList) {
        log.debug((Object)("Enter: getCatalogInstance(" + molecule + "," + calculated_freq_asString + "," + calculated_freq + "," + calculated_freq_err + "," + measured_freq_asString + "," + measured_freq + "," + measured_freq_err + "," + energy_level + "," + quantum_number + "," + j_up + "," + ka_up + "," + kc_up + "," + j_low + "," + ka_low + "," + kc_low + "," + relative_intensity_hfs + "," + line_strength_sij + "," + slaim_ref + "," + moleculeName + "," + lineList + ")"));
        CatalogBean bean = this.getCatalogBean();
        bean.setMolecule(molecule).setCalculatedFrequencyString(calculated_freq_asString).setCalculatedFrequency(calculated_freq).setCalculatedFrequencyError(calculated_freq_err).setMeasuredFrequencyString(measured_freq_asString).setMeasuredFrequency(measured_freq).setMeasuredFrequencyError(measured_freq_err).setEnergyLevel(energy_level).setQuantumNumbers(quantum_number).setJUp(j_up).setKaUp(ka_up).setKcUp(kc_up).setJLow(j_low).setKaLow(ka_low).setKcLow(kc_low).setRelativeIntensity(relative_intensity_hfs).setLineStrength(line_strength_sij).setReference(slaim_ref).setMoleculeName(moleculeName).setLineList(lineList);
        return bean;
    }

    public static Catalog getCatalog(ResultSet resultSet) throws SQLException {
        return CatalogFactory.getInstance().getCatalogInstance(resultSet);
    }

    protected Catalog getCatalogInstance(ResultSet resultSet) throws SQLException {
        log.debug((Object)("Enter: getCatalogInstance(" + resultSet + ")"));
        return CatalogFactory.getCatalog(ResultSetTools.getString((ResultSet)resultSet, (String)"molecule"), ResultSetTools.getString((ResultSet)resultSet, (String)"calculated_freq"), ResultSetTools.getDouble((ResultSet)resultSet, (String)"calculated_freq"), ResultSetTools.getBigDecimal((ResultSet)resultSet, (String)"calculated_freq_err"), ResultSetTools.getString((ResultSet)resultSet, (String)"measured_freq"), ResultSetTools.getBigDecimal((ResultSet)resultSet, (String)"measured_freq"), ResultSetTools.getBigDecimal((ResultSet)resultSet, (String)"measured_freq_err"), ResultSetTools.getBigDecimal((ResultSet)resultSet, (String)"energy_level"), ResultSetTools.getString((ResultSet)resultSet, (String)"quantum_number"), ResultSetTools.getBigDecimal((ResultSet)resultSet, (String)"j_up"), ResultSetTools.getBigDecimal((ResultSet)resultSet, (String)"ka_up"), ResultSetTools.getBigDecimal((ResultSet)resultSet, (String)"kc_up"), ResultSetTools.getBigDecimal((ResultSet)resultSet, (String)"j_low"), ResultSetTools.getBigDecimal((ResultSet)resultSet, (String)"ka_low"), ResultSetTools.getBigDecimal((ResultSet)resultSet, (String)"kc_low"), ResultSetTools.getBigDecimal((ResultSet)resultSet, (String)"relative_intensity_hfs"), ResultSetTools.getBigDecimal((ResultSet)resultSet, (String)"line_strength_sij"), ResultSetTools.getString((ResultSet)resultSet, (String)"slaim_ref"), ResultSetTools.getString((ResultSet)resultSet, (String)"molecule"), null);
    }

    public static Catalog getCatalog(int lineNumber, String delimitedData) {
        return CatalogFactory.getInstance().getCatalogInstance(lineNumber, delimitedData);
    }

    protected Catalog getCatalogInstance(int lineNumber, String delimitedData) {
        log.debug((Object)("Enter: getCatalogInstance(" + lineNumber + "," + delimitedData + ")"));
        StringSplitterDecorator tokens = new StringSplitterDecorator(delimitedData, '\t');
        String molecule = tokens.getString("molecule");
        String CALCULATED_FREQ_ASSTRING = tokens.getString("calculated_freq_asString");
        double calculatedFrequency = tokens.getDouble("calculated_freq");
        BigDecimal calculatedFrequencyError = tokens.getNullBigDecimal("calculated_freq_err");
        String MEASURED_FREQ_ASSTRING = tokens.getNullString("measured_freq_asString");
        BigDecimal measuredFrequency = tokens.getNullBigDecimal("measured_freq");
        BigDecimal measuredFrequencyError = tokens.getNullBigDecimal("measured_freq_err");
        BigDecimal energyLevel = tokens.getNullBigDecimal("energy_level");
        String quantumNumbers = tokens.getNullString("quantum_numbers");
        BigDecimal jUp = tokens.getNullBigDecimal("j_up");
        BigDecimal kaUp = tokens.getNullBigDecimal("ka_up");
        BigDecimal kcUp = tokens.getNullBigDecimal("kc_up");
        BigDecimal jLow = tokens.getNullBigDecimal("j_low");
        BigDecimal kaLow = tokens.getNullBigDecimal("ka_low");
        BigDecimal kcLow = tokens.getNullBigDecimal("kc_low");
        BigDecimal relativeIntensity = tokens.getNullBigDecimal("relative_intensity_hfs");
        BigDecimal lineStrength = tokens.getNullBigDecimal("line_strength_sij");
        String reference = tokens.getNullString("slaim_ref");
        String MOLECULE_NAME = tokens.getNullString("molecule_name");
        return CatalogFactory.getCatalog(molecule, CALCULATED_FREQ_ASSTRING, calculatedFrequency, calculatedFrequencyError, MEASURED_FREQ_ASSTRING, measuredFrequency, measuredFrequencyError, energyLevel, quantumNumbers, jUp, kaUp, kcUp, jLow, kaLow, kcLow, relativeIntensity, lineStrength, reference, MOLECULE_NAME, null);
    }

    public static Catalog getCatalog(LineToParse ltp) throws ParseException {
        return CatalogFactory.getInstance().getCatalogInstance(ltp);
    }

    protected Catalog getCatalogInstance(LineToParse ltp) throws ParseException {
        String molecule = null;
        MoleculeNameParser p = new MoleculeNameParser(ltp);
        molecule = p.getName();
        String CALCULATED_FREQ_ASSTRING = null;
        double calculatedFrequency = 0.0;
        BigDecimal calculatedFrequencyError = null;
        CalculatedFrequencyParser p2 = new CalculatedFrequencyParser(ltp);
        CALCULATED_FREQ_ASSTRING = p2.getChunk();
        calculatedFrequency = p2.getFrequency().doubleValue();
        calculatedFrequencyError = p2.getError();
        String MEASURED_FREQ_ASSTRING = null;
        BigDecimal measuredFrequency = null;
        BigDecimal measuredFrequencyError = null;
        MeasuredFrequencyParser p3 = new MeasuredFrequencyParser(ltp);
        MEASURED_FREQ_ASSTRING = p3.getChunk();
        measuredFrequency = p3.getFrequency();
        measuredFrequencyError = p3.getError();
        BigDecimal energyLevel = null;
        EnergyLevelParser p4 = new EnergyLevelParser(ltp);
        energyLevel = p4.getEnergyLevel();
        String quantumNumbers = null;
        BigDecimal jUp = null;
        BigDecimal kaUp = null;
        BigDecimal kcUp = null;
        BigDecimal jLow = null;
        BigDecimal kaLow = null;
        BigDecimal kcLow = null;
        QuantumNumbersParser p5 = new QuantumNumbersParser(ltp);
        quantumNumbers = p5.getChunk();
        jUp = p5.getJUp();
        kaUp = p5.getKaUp();
        kcUp = p5.getKcUp();
        jLow = p5.getJLow();
        kaLow = p5.getKaLow();
        kcLow = p5.getKcLow();
        BigDecimal relativeIntensity = null;
        RelativeIntensityParser p6 = new RelativeIntensityParser(ltp);
        relativeIntensity = p6.getRelativeIntensity();
        BigDecimal lineStrength = null;
        LineStrengthParser p7 = new LineStrengthParser(ltp);
        lineStrength = p7.getLineStrength();
        String reference = null;
        ReferenceParser p8 = new ReferenceParser(ltp);
        reference = p8.getReference();
        String MOLECULE_NAME = null;
        MOLECULE_NAME = molecule;
        String lineList = null;
        lineList = "SLAIM";
        return CatalogFactory.getCatalog(molecule, CALCULATED_FREQ_ASSTRING, calculatedFrequency, calculatedFrequencyError, MEASURED_FREQ_ASSTRING, measuredFrequency, measuredFrequencyError, energyLevel, quantumNumbers, jUp, kaUp, kcUp, jLow, kaLow, kcLow, relativeIntensity, lineStrength, reference, MOLECULE_NAME, lineList);
    }

    protected CatalogBean getCatalogBean() {
        return new CatalogBean();
    }
}

