/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.catalog;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ferris.astronomy.data.catalog.Catalog;
import org.ferris.astronomy.data.catalog.CatalogFactory;
import org.ferris.astronomy.data.catalog.CatalogIterator;
import org.ferris.io.LineReader;
import org.ferris.io.LineReaderByFile;

public class CatalogIteratorByFile
implements CatalogIterator {
    private File file;
    private State state;

    public CatalogIteratorByFile(File file) {
        this.file = file;
        this.state = new StateIsOpen();
    }

    public void close() {
        this.state.close();
    }

    public boolean hasNext() {
        return this.state.hasNext();
    }

    public Catalog next() {
        return (Catalog)this.state.next();
    }

    public void remove() {
        this.state.remove();
    }

    private class StateIsOpen
    implements State {
        private LineReader reader;
        private Catalog next;

        private StateIsOpen() {
            try {
                this.reader = new LineReaderByFile(CatalogIteratorByFile.this.file);
            }
            catch (IOException e) {
                throw new RuntimeException("An IOException was thrown in " + this.getClass().getName() + " while trying to create a LineReaderByFile to file" + " " + CatalogIteratorByFile.this.file);
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            this.setNext();
            return this.next != null;
        }

        public Catalog next() {
            this.setNext();
            if (this.next == null) {
                throw new NoSuchElementException("Stream to file \"" + CatalogIteratorByFile.this.file + "\" has been closed and the state has been changed to StateIsClosed.");
            }
            Catalog o = this.next;
            this.next = null;
            return o;
        }

        private void setNext() {
            if (this.next != null) {
                return;
            }
            String line = null;
            try {
                line = this.reader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(this.getClass().getName() + " had a problem reading the next line.", e);
            }
            if (line == null) {
                this.close();
            } else {
                this.next = CatalogFactory.getCatalog(this.reader.getLineNumber(), line);
            }
        }

        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(this.getClass().getName() + " had a problem closing the reader to file: " + CatalogIteratorByFile.this.file, e);
            }
            finally {
                this.reader = null;
                CatalogIteratorByFile.this.state = new StateIsClosed();
            }
        }
    }

    private class StateIsClosed
    implements State {
        private StateIsClosed() {
        }

        public boolean hasNext() {
            return false;
        }

        public Catalog next() {
            throw new NoSuchElementException("The Iterator state is now StateIsClosed.");
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface State
    extends Iterator<Catalog> {
        public void close();
    }
}

