/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.catalog;

import java.io.File;
import java.util.LinkedList;
import org.ferris.astronomy.data.catalog.CatalogIterator;
import org.ferris.astronomy.data.catalog.CatalogIteratorByFile;
import org.ferris.astronomy.data.catalog.CatalogIteratorByNothing;
import org.ferris.astronomy.data.catalog.CatalogList;

public class CatalogListByFile
implements CatalogList {
    protected int size;
    protected File file;
    protected LinkedList<CatalogIteratorByFile> iterators;

    public CatalogListByFile(int size, File file) {
        this.size = size;
        this.file = file;
        this.iterators = new LinkedList();
        Runtime.getRuntime().addShutdownHook(new DeleteThread());
    }

    public void clear() {
        if (this.file == null) {
            System.out.println(this.toString() + " Already cleared, no file to delete.");
            return;
        }
        for (CatalogIteratorByFile item : this.iterators) {
            item.close();
        }
        this.iterators.clear();
        if (this.file.exists()) {
            System.out.println(this.toString() + " Deleting file:" + " " + this.file + " (" + this.file.delete() + ")");
        } else {
            System.out.println(this.toString() + " File:" + " " + this.file + " no longer exists.");
        }
        this.file = null;
    }

    public CatalogIterator getIterator() {
        if (this.file == null) {
            return new CatalogIteratorByNothing();
        }
        CatalogIteratorByFile o = new CatalogIteratorByFile(this.file);
        this.iterators.add(o);
        return o;
    }

    public int getSize() {
        return this.size;
    }

    class DeleteThread
    extends Thread {
        DeleteThread() {
        }

        public void run() {
            System.out.println(CatalogListByFile.this.toString() + " Running shutdown hook.");
            CatalogListByFile.this.clear();
        }
    }
}

