/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.ferris.astronomy.data.catalog.CatalogListByFile;
import org.ferris.astronomy.io.LineNumberReaderWithErrorChecking;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.lang.Code;
import org.ferris.astronomy.net.runner.HttpResponseHandlerForPlainText;
import org.ferris.io.LineWriterByTempFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CatalogListByFileResponseHandler
extends HttpResponseHandlerForPlainText<CatalogListByFile> {
    CatalogListByFileResponseHandler() {
    }

    @Override
    public List<CatalogListByFile> response(InputStream response) {
        List<CatalogListByFile> retval = super.response(response);
        LineNumberReaderWithErrorChecking reader = this.getLineNumberReaderWithErrorChecking();
        try {
            LineWriterByTempFile writer = new LineWriterByTempFile("CatalogData", ".tmp");
            String line = reader.getLine();
            while (line != null) {
                writer.writeln(line);
                line = reader.getLine();
            }
            writer.close();
            retval.add(new CatalogListByFile(writer.getLineCount(), writer.getFile()));
            List<CatalogListByFile> list = retval;
            return list;
        }
        catch (IOException e) {
            throw new AstronomyException(Code.ASTR000060, (Throwable)e, new Object[0]);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable ignore) {}
            }
        }
    }
}

