/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.catalog;

import java.math.BigDecimal;
import java.util.List;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.catalog.CatalogList;
import org.ferris.astronomy.data.catalog.CatalogListByFile;
import org.ferris.astronomy.data.catalog.CatalogListByFileResponseHandler;
import org.ferris.astronomy.data.catalog.CatalogServices;
import org.ferris.astronomy.data.catalog.FindConstraints;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.net.runner.HttpRequestRunnerForLineListServices;

public class CatalogServicesByPhp
implements CatalogServices {
    private String PAGE = "get.catalog.php";
    protected Logger log = Logger.getLogger(this.getClass());

    private String getParameter(BigDecimal bd) {
        if (bd == null) {
            return "";
        }
        return bd.toPlainString();
    }

    private String getParameter(double d) {
        return String.valueOf(d);
    }

    public CatalogList findByConstraints(FindConstraints constraints) throws AstronomyException {
        this.log.info((Object)("Enter: findByConstraints() " + constraints));
        this.log.info((Object)"Creating runner <CatalogListByFile>");
        HttpRequestRunnerForLineListServices runner = new HttpRequestRunnerForLineListServices(this.PAGE);
        this.log.info((Object)"Building query");
        StringBuilder query = new StringBuilder();
        query.append(runner.getResource());
        query.append("?");
        query.append("linelist").append("=").append("?");
        query.append("&");
        query.append("molecule").append("=").append("?");
        query.append("&");
        query.append("calc_freq_mhz_min").append("=").append("?");
        query.append("&");
        query.append("calc_freq_mhz_max").append("=").append("?");
        query.append("&");
        query.append("energy_level").append("=").append("?");
        query.append("&");
        query.append("sij").append("=").append("?");
        query.append("&");
        query.append("j_up_min").append("=").append("?");
        query.append("&");
        query.append("j_up_max").append("=").append("?");
        query.append("&");
        query.append("ka_up_min").append("=").append("?");
        query.append("&");
        query.append("ka_up_max").append("=").append("?");
        query.append("&");
        query.append("kc_up_min").append("=").append("?");
        query.append("&");
        query.append("kc_up_max").append("=").append("?");
        query.append("&");
        query.append("j_low_min").append("=").append("?");
        query.append("&");
        query.append("j_low_max").append("=").append("?");
        query.append("&");
        query.append("ka_low_min").append("=").append("?");
        query.append("&");
        query.append("ka_low_max").append("=").append("?");
        query.append("&");
        query.append("kc_low_min").append("=").append("?");
        query.append("&");
        query.append("kc_low_max").append("=").append("?");
        this.log.info((Object)("Query: " + query.toString()));
        this.log.info((Object)"Setting query parameters");
        runner.addParameter(constraints.getLineList());
        runner.addParameter(constraints.getMolecule());
        runner.addParameter(this.getParameter(constraints.getCalculatedFrequencyMin()));
        runner.addParameter(this.getParameter(constraints.getCalculatedFrequencyMax()));
        runner.addParameter(this.getParameter(constraints.getEnergyLevel()));
        runner.addParameter(this.getParameter(constraints.getSij()));
        runner.addParameter(this.getParameter(constraints.getJUpMin()));
        runner.addParameter(this.getParameter(constraints.getJUpMax()));
        runner.addParameter(this.getParameter(constraints.getKaUpMin()));
        runner.addParameter(this.getParameter(constraints.getKaUpMax()));
        runner.addParameter(this.getParameter(constraints.getKcUpMin()));
        runner.addParameter(this.getParameter(constraints.getKcUpMax()));
        runner.addParameter(this.getParameter(constraints.getJLowMin()));
        runner.addParameter(this.getParameter(constraints.getJLowMax()));
        runner.addParameter(this.getParameter(constraints.getKaLowMin()));
        runner.addParameter(this.getParameter(constraints.getKaLowMax()));
        runner.addParameter(this.getParameter(constraints.getKcLowMin()));
        runner.addParameter(this.getParameter(constraints.getKcLowMax()));
        this.log.info((Object)"Running query");
        List list = runner.get(query.toString(), new CatalogListByFileResponseHandler());
        this.log.info((Object)"Creating CatalogList");
        CatalogListByFile retval = null;
        retval = (CatalogListByFile)list.get(0);
        this.log.info((Object)("Returning vCatalogList, size=" + retval.getSize()));
        return retval;
    }
}

