/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.ferris.astronomy.data.catalog.CatalogList;
import org.ferris.astronomy.data.catalog.CatalogListByFile;
import org.ferris.astronomy.data.catalog.CatalogServices;
import org.ferris.astronomy.data.catalog.FindConstraints;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.lang.Code;
import org.ferris.io.LineWriterByTempFile;
import org.ferris.lang.string.StringTools;
import org.ferris.sql.ConnectionFactory;
import org.ferris.sql.ConnectionTools;

public class CatalogServicesBySql
implements CatalogServices {
    private ConnectionFactory factory;

    public CatalogServicesBySql(ConnectionFactory factory) {
        this.factory = factory;
    }

    public Connection getConnection() throws SQLException {
        return this.factory.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public CatalogList findByConstraints(FindConstraints constraints) throws AstronomyException {
        String sql = this.getSql(constraints);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        conn = this.getConnection();
        stmt = this.setParameters(sql, conn.prepareStatement(sql), constraints);
        rs = stmt.executeQuery();
        LineWriterByTempFile writer = new LineWriterByTempFile("CatalogData", ".tmp");
        while (rs.next()) {
            writer.write(StringTools.trimToDefault((String)rs.getString("molecule"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("calculated_freq_asString"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("calculated_freq"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("calculated_freq_err"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("measured_freq_asString"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("measured_freq"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("measured_freq_err"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("energy_level"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("quantum_number"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("j_up"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("ka_up"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("kc_up"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("j_low"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("ka_low"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("kc_low"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("relative_intensity_hfs"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("line_strength_sij"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("slaim_ref"), (String)""));
            writer.write("\t");
            writer.write(StringTools.trimToDefault((String)rs.getString("molecule_name"), (String)""));
            writer.writeln("");
        }
        writer.close();
        CatalogListByFile catalogListByFile = new CatalogListByFile(writer.getLineCount(), writer.getFile());
        ConnectionTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return catalogListByFile;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        throw throwable;
                    }
                    catch (AstronomyException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new AstronomyException(Code.ASTR000052, t, sql);
                    }
                }
                catch (Throwable throwable2) {
                    ConnectionTools.close((Connection)conn, stmt, rs);
                    throw throwable2;
                }
            }
        }
    }

    protected PreparedStatement setParameters(String sql, PreparedStatement stmt, FindConstraints c) throws SQLException {
        int x = 0;
        if (sql.indexOf("linelist = ?") > 0) {
            stmt.setString(++x, c.getLineList());
        }
        if (sql.indexOf("molecule = ?") > 0) {
            stmt.setString(++x, c.getMolecule());
        }
        return stmt;
    }

    protected String getSql(FindConstraints c) {
        StringBuffer sp = new StringBuffer();
        sp.append("select ");
        sp.append(" molecule, calculated_freq_asString, calculated_freq, calculated_freq_err, measured_freq_asString, measured_freq, measured_freq_err, energy_level, quantum_number, j_up, ka_up, kc_up, j_low, ka_low, kc_low, relative_intensity_hfs, line_strength_sij, slaim_ref, molecule_name ");
        sp.append(" from catalog ");
        sp.append(" where ");
        sp.append(" ( ");
        sp.append(" calculated_freq >= ").append(c.getCalculatedFrequencyMin());
        sp.append(" and ");
        sp.append(" calculated_freq <= ").append(c.getCalculatedFrequencyMax());
        sp.append(" ) ");
        if (c.getLineList() != null) {
            sp.append(" and ");
            sp.append(" linelist = ? ");
        }
        if (c.getMolecule() != null) {
            sp.append(" and ");
            sp.append(" molecule = ? ");
        }
        if (c.getEnergyLevel() != null) {
            sp.append(" and ");
            sp.append(" energy_level < ").append(c.getEnergyLevel());
        }
        if (c.getSij() != null) {
            sp.append(" and ");
            sp.append(" ( ");
            sp.append(" line_strength_sij > ").append(c.getSij());
            sp.append(" or ");
            sp.append(" relative_intensity_hfs > ").append(c.getSij());
            sp.append(" ) ");
        }
        if (c.getJUpMin() != null && c.getJUpMax() != null) {
            sp.append(" and ");
            sp.append(" ( ");
            sp.append(" j_up >= ").append(c.getJUpMin());
            sp.append(" and ");
            sp.append(" j_up <= ").append(c.getJUpMax());
            sp.append(" ) ");
        }
        if (c.getKaUpMin() != null && c.getKaUpMax() != null) {
            sp.append(" and ");
            sp.append(" ( ");
            sp.append(" ka_up >= ").append(c.getKaUpMin());
            sp.append(" and ");
            sp.append(" ka_up <= ").append(c.getKaUpMax());
            sp.append(" ) ");
        }
        if (c.getKcUpMin() != null && c.getKcUpMax() != null) {
            sp.append(" and ");
            sp.append(" ( ");
            sp.append(" kc_up >= ").append(c.getKcUpMin());
            sp.append(" and ");
            sp.append(" kc_up <= ").append(c.getKcUpMax());
            sp.append(" ) ");
        }
        if (c.getJLowMin() != null && c.getJLowMax() != null) {
            sp.append(" and ");
            sp.append(" ( ");
            sp.append(" j_low >= ").append(c.getJLowMin());
            sp.append(" and ");
            sp.append(" j_low <= ").append(c.getJLowMax());
            sp.append(" ) ");
        }
        if (c.getKaLowMin() != null && c.getKaLowMax() != null) {
            sp.append(" and ");
            sp.append(" ( ");
            sp.append(" ka_low >= ").append(c.getKaLowMin());
            sp.append(" and ");
            sp.append(" ka_low <= ").append(c.getKaLowMax());
            sp.append(" ) ");
        }
        if (c.getKcLowMin() != null && c.getKcLowMax() != null) {
            sp.append(" and ");
            sp.append(" ( ");
            sp.append(" kc_low >= ").append(c.getKcLowMin());
            sp.append(" and ");
            sp.append(" kc_low <= ").append(c.getKcLowMax());
            sp.append(" ) ");
        }
        sp.append(" order by calculated_freq, molecule ");
        return sp.toString();
    }
}

