/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.catalog;

import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.ferris.astronomy.math.BigDecimalTools;

public class FindConstraints {
    private String lineList;
    private String molecule;
    private double calculatedFrequencyMin;
    private double calculatedFrequencyMax;
    private BigDecimal energyLevel;
    private BigDecimal sij;
    private BigDecimal jUpMin;
    private BigDecimal jUpMax;
    private BigDecimal kaUpMin;
    private BigDecimal kaUpMax;
    private BigDecimal kcUpMin;
    private BigDecimal kcUpMax;
    private BigDecimal jLowMin;
    private BigDecimal jLowMax;
    private BigDecimal kaLowMin;
    private BigDecimal kaLowMax;
    private BigDecimal kcLowMin;
    private BigDecimal kcLowMax;

    public String toString() {
        return "[FindConstraints lineList=" + this.lineList + " ,molecule=" + this.molecule + " ,calculatedFrequencyMin=" + this.calculatedFrequencyMin + " ,calculatedFrequencyMax=" + this.calculatedFrequencyMax + " ,energyLevel=" + this.energyLevel + " ,sij=" + this.sij + " ,jUpMin=" + this.jUpMin + " ,jUpMax=" + this.jUpMax + " ,kaUpMin=" + this.kaUpMin + " ,kaUpMax=" + this.kaUpMax + " ,kcUpMin=" + this.kcUpMin + " ,kcUpMax=" + this.kcUpMax + " ,jLowMin=" + this.jLowMin + " ,jLowMax=" + this.jLowMax + " ,kaLowMin=" + this.kaLowMin + " ,kaLowMax=" + this.kaLowMax + " ,kcLowMin=" + this.kcLowMin + " ,kcLowMax=" + this.kcLowMax + "]";
    }

    public void setKcLow(String min, String max) {
        min = StringUtils.trimToNull((String)min);
        max = StringUtils.trimToNull((String)max);
        if (min != null && max != null) {
            this.kcLowMin = BigDecimalTools.getBigDecimal(min);
            this.kcLowMax = BigDecimalTools.getBigDecimal(max);
        }
    }

    public void setKaLow(String min, String max) {
        min = StringUtils.trimToNull((String)min);
        max = StringUtils.trimToNull((String)max);
        if (min != null && max != null) {
            this.kaLowMin = BigDecimalTools.getBigDecimal(min);
            this.kaLowMax = BigDecimalTools.getBigDecimal(max);
        }
    }

    public void setJLow(String min, String max) {
        min = StringUtils.trimToNull((String)min);
        max = StringUtils.trimToNull((String)max);
        if (min != null && max != null) {
            this.jLowMin = BigDecimalTools.getBigDecimal(min);
            this.jLowMax = BigDecimalTools.getBigDecimal(max);
        }
    }

    public void setKcUp(String min, String max) {
        min = StringUtils.trimToNull((String)min);
        max = StringUtils.trimToNull((String)max);
        if (min != null && max != null) {
            this.kcUpMin = BigDecimalTools.getBigDecimal(min);
            this.kcUpMax = BigDecimalTools.getBigDecimal(max);
        }
    }

    public void setKaUp(String min, String max) {
        min = StringUtils.trimToNull((String)min);
        max = StringUtils.trimToNull((String)max);
        if (min != null && max != null) {
            this.kaUpMin = BigDecimalTools.getBigDecimal(min);
            this.kaUpMax = BigDecimalTools.getBigDecimal(max);
        }
    }

    public void setJUp(String min, String max) {
        min = StringUtils.trimToNull((String)min);
        max = StringUtils.trimToNull((String)max);
        if (min != null && max != null) {
            this.jUpMin = BigDecimalTools.getBigDecimal(min);
            this.jUpMax = BigDecimalTools.getBigDecimal(max);
        }
    }

    public void setSij(String str) {
        if ((str = StringUtils.trimToNull((String)str)) != null) {
            this.sij = BigDecimalTools.getBigDecimal(str);
        }
    }

    public void setEnergyLevel(String str) {
        if ((str = StringUtils.trimToNull((String)str)) != null) {
            this.energyLevel = BigDecimalTools.getBigDecimal(str);
        }
    }

    public void setCalculatedFrequency(String min, String max) {
        this.calculatedFrequencyMin = BigDecimalTools.getBigDecimal(min).doubleValue();
        this.calculatedFrequencyMax = BigDecimalTools.getBigDecimal(max).doubleValue();
    }

    public void setCalculatedFrequency(double min, double max) {
        this.calculatedFrequencyMin = min;
        this.calculatedFrequencyMax = max;
    }

    public void setMolecule(String molecule) {
        this.molecule = StringUtils.trimToNull((String)molecule);
    }

    public void setLineList(String lineList) {
        this.lineList = StringUtils.trimToNull((String)lineList);
    }

    public double getCalculatedFrequencyMax() {
        return this.calculatedFrequencyMax;
    }

    public double getCalculatedFrequencyMin() {
        return this.calculatedFrequencyMin;
    }

    public BigDecimal getEnergyLevel() {
        return this.energyLevel;
    }

    public BigDecimal getJLowMax() {
        return this.jLowMax;
    }

    public BigDecimal getJLowMin() {
        return this.jLowMin;
    }

    public BigDecimal getJUpMax() {
        return this.jUpMax;
    }

    public BigDecimal getJUpMin() {
        return this.jUpMin;
    }

    public BigDecimal getKaLowMax() {
        return this.kaLowMax;
    }

    public BigDecimal getKaLowMin() {
        return this.kaLowMin;
    }

    public BigDecimal getKaUpMax() {
        return this.kaUpMax;
    }

    public BigDecimal getKaUpMin() {
        return this.kaUpMin;
    }

    public BigDecimal getKcLowMax() {
        return this.kcLowMax;
    }

    public BigDecimal getKcLowMin() {
        return this.kcLowMin;
    }

    public BigDecimal getKcUpMax() {
        return this.kcUpMax;
    }

    public BigDecimal getKcUpMin() {
        return this.kcUpMin;
    }

    public String getLineList() {
        return this.lineList;
    }

    public String getMolecule() {
        return this.molecule;
    }

    public BigDecimal getSij() {
        return this.sij;
    }
}

