/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.h;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.h.H;
import org.ferris.astronomy.data.h.HBean;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.astronomy.util.split.StringSplitterDecorator;

public class HFactory {
    private static Logger log = Logger.getLogger(HFactory.class);

    public static H getH(double frequency, String name) {
        log.debug((Object)("Enter: getH(" + frequency + "," + name + ")"));
        HBean bean = new HBean();
        bean.setFrequency(BigDecimalTools.getBigDecimal(frequency));
        bean.setName(name);
        return bean;
    }

    public static H getH(ResultSet resultSet) throws SQLException {
        log.debug((Object)("Enter: getH(" + resultSet + ")"));
        HBean bean = new HBean();
        bean.setFrequency(BigDecimalTools.getBigDecimal(resultSet.getString("frequency_mhz")));
        bean.setName(resultSet.getString("name"));
        return bean;
    }

    public static H getH(int lineNumber, String lineOfData, char deliminator) throws AstronomyException {
        log.debug((Object)("Enter: getH(" + lineNumber + "," + deliminator + "," + lineOfData + ")"));
        StringSplitterDecorator tokens = new StringSplitterDecorator(lineOfData, deliminator);
        HBean bean = new HBean();
        bean.setFrequency(tokens.getBigDecimal("frequency"));
        bean.setName(tokens.getNullString("name"));
        return bean;
    }
}

