/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.h;

import java.math.BigDecimal;
import org.ferris.astronomy.data.h.H;
import org.ferris.astronomy.data.h.HFactory;
import org.ferris.astronomy.data.h.HList;
import org.ferris.astronomy.data.h.HServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.math.BigDecimalTools;

public class HServicesByGeneration
implements HServices {
    private static HList data = new HList(2000);

    public HList findByFrequency(double freqMin, double freqMax) throws AstronomyException {
        HList matches = new HList();
        BigDecimal min = BigDecimalTools.getBigDecimal(freqMin);
        BigDecimal max = BigDecimalTools.getBigDecimal(freqMax);
        for (H item : data) {
            int vMin = item.getFrequency().compareTo(min);
            int vMax = item.getFrequency().compareTo(max);
            if (vMin < 0 || vMax > 0) continue;
            matches.add(item);
        }
        return matches;
    }

    static {
        double rh = 3.28805129 * Math.pow(10.0, 9.0);
        double j = 0.0;
        for (double i = 1.0; i <= 400.0; i += 1.0) {
            for (int m = 1; m <= 5; ++m) {
                j = i + (double)m;
                data.add(HFactory.getH(BigDecimalTools.getBigDecimal(rh * (1.0 / (i * i) - 1.0 / (j * j))).doubleValue(), ""));
            }
        }
    }
}

