/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.h;

import java.util.List;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.h.HList;
import org.ferris.astronomy.data.h.HResponseHandler;
import org.ferris.astronomy.data.h.HServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.astronomy.net.runner.HttpRequestRunnerForLineListServices;

public class HServicesByPhp
implements HServices {
    private static String PAGE = "get.h.php";
    protected Logger log = Logger.getLogger(this.getClass());

    public HList findByFrequency(double freqMin, double freqMax) throws AstronomyException {
        this.log.info((Object)("Enter: findByFrequency(" + freqMin + "," + freqMax + ")"));
        this.log.info((Object)"Creating runner <H>");
        HttpRequestRunnerForLineListServices runner = new HttpRequestRunnerForLineListServices(PAGE);
        this.log.info((Object)"Building query");
        StringBuilder query = new StringBuilder();
        query.append(runner.getResource());
        query.append("?");
        query.append("minFreqMhz").append("=").append("?");
        query.append("&");
        query.append("maxFreqMhz").append("=").append("?");
        this.log.info((Object)("Query: " + query.toString()));
        this.log.info((Object)"Setting query parameters");
        runner.addParameter(BigDecimalTools.getBigDecimal(freqMin).toPlainString());
        runner.addParameter(BigDecimalTools.getBigDecimal(freqMax).toPlainString());
        this.log.info((Object)"Running query");
        List list = runner.get(query.toString(), new HResponseHandler());
        this.log.info((Object)"Creating HList");
        HList retval = null;
        retval = new HList();
        retval.addAll(list);
        list.clear();
        this.log.info((Object)("Returning HList, size=" + retval.size()));
        return retval;
    }
}

