/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.h;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.ferris.astronomy.data.ServicesBySql;
import org.ferris.astronomy.data.h.HFactory;
import org.ferris.astronomy.data.h.HList;
import org.ferris.astronomy.data.h.HServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.lang.Code;
import org.ferris.sql.ConnectionFactory;
import org.ferris.sql.ConnectionTools;

public class HServicesBySql
extends ServicesBySql
implements HServices {
    public HServicesBySql(ConnectionFactory factory) {
        super(factory);
    }

    public HList findByFrequency(double freqMin, double freqMax) throws AstronomyException {
        HList hList;
        StringBuffer sp = new StringBuffer("select frequency_mhz, name from h ");
        sp.append(" where ");
        sp.append(" frequency_mhz between ").append(freqMin).append(" and ").append(freqMax);
        sp.append(" order by frequency_mhz asc ");
        String sql = sp.toString();
        sp.setLength(0);
        sp = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            HList list = new HList();
            while (rs.next()) {
                list.add(HFactory.getH(rs));
            }
            hList = list;
        }
        catch (Throwable t) {
            try {
                throw new AstronomyException(Code.ASTR000052, t, sql);
            }
            catch (Throwable throwable) {
                ConnectionTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        ConnectionTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return hList;
    }
}

