/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.he;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.he.HE;
import org.ferris.astronomy.data.he.HEBean;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.astronomy.util.split.StringSplitterDecorator;

public class HEFactory {
    private static Logger log = Logger.getLogger(HEFactory.class);

    public static HE getHE(double frequency, String name) {
        log.debug((Object)("Enter: getHE(" + frequency + "," + name + ")"));
        HEBean bean = new HEBean();
        bean.setFrequency(BigDecimalTools.getBigDecimal(frequency));
        bean.setName(name);
        return bean;
    }

    public static HE getHE(ResultSet resultSet) throws SQLException {
        log.debug((Object)("Enter: getHE(" + resultSet + ")"));
        HEBean bean = new HEBean();
        bean.setFrequency(BigDecimalTools.getBigDecimal(resultSet.getString("frequency_mhz")));
        bean.setName(resultSet.getString("name"));
        return bean;
    }

    public static HE getHE(int lineNumber, String lineOfData, char deliminator) throws AstronomyException {
        log.debug((Object)("Enter: getHE(" + lineNumber + "," + deliminator + "," + lineOfData + ")"));
        StringSplitterDecorator tokens = new StringSplitterDecorator(lineOfData, deliminator);
        HEBean bean = new HEBean();
        bean.setFrequency(tokens.getBigDecimal("frequency"));
        bean.setName(tokens.getNullString("name"));
        return bean;
    }
}

