/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.he;

import java.math.BigDecimal;
import org.ferris.astronomy.data.he.HE;
import org.ferris.astronomy.data.he.HEFactory;
import org.ferris.astronomy.data.he.HEList;
import org.ferris.astronomy.data.he.HEServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.math.BigDecimalTools;

public class HEServicesByGeneration
implements HEServices {
    private static HEList data = new HEList(2000);

    public HEList findByFrequency(double freqMin, double freqMax) throws AstronomyException {
        HEList matches = new HEList();
        BigDecimal min = BigDecimalTools.getBigDecimal(freqMin);
        BigDecimal max = BigDecimalTools.getBigDecimal(freqMax);
        for (HE item : data) {
            int vMin = item.getFrequency().compareTo(min);
            int vMax = item.getFrequency().compareTo(max);
            if (vMin < 0 || vMax > 0) continue;
            matches.add(item);
        }
        return matches;
    }

    static {
        double rhe = 3.28939226 * Math.pow(10.0, 9.0);
        double j = 0.0;
        for (double i = 1.0; i <= 400.0; i += 1.0) {
            for (int m = 1; m <= 5; ++m) {
                j = i + (double)m;
                data.add(HEFactory.getHE(BigDecimalTools.getBigDecimal(rhe * (1.0 / (i * i) - 1.0 / (j * j))).doubleValue(), ""));
            }
        }
    }
}

