/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.he;

import java.util.List;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.he.HEList;
import org.ferris.astronomy.data.he.HEServices;
import org.ferris.astronomy.data.he.HResponseHandler;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.astronomy.net.runner.HttpRequestRunnerForLineListServices;

public class HEServicesByPhp
implements HEServices {
    private static String PAGE = "get.he.php";
    protected Logger log = Logger.getLogger(this.getClass());

    public HEList findByFrequency(double freqMin, double freqMax) throws AstronomyException {
        this.log.info((Object)("Enter: findByFrequency(" + freqMin + "," + freqMax + ")"));
        this.log.info((Object)"Creating runner <HE>");
        HttpRequestRunnerForLineListServices runner = new HttpRequestRunnerForLineListServices(PAGE);
        this.log.info((Object)"Building query");
        StringBuilder query = new StringBuilder();
        query.append(runner.getResource());
        query.append("?");
        query.append("minFreqMhz").append("=").append("?");
        query.append("&");
        query.append("maxFreqMhz").append("=").append("?");
        this.log.info((Object)("Query: " + query.toString()));
        this.log.info((Object)"Setting query parameters");
        runner.addParameter(BigDecimalTools.getBigDecimal(freqMin).toPlainString());
        runner.addParameter(BigDecimalTools.getBigDecimal(freqMax).toPlainString());
        this.log.info((Object)"Running query");
        List list = runner.get(query.toString(), new HResponseHandler());
        this.log.info((Object)"Creating HEList");
        HEList retval = null;
        retval = new HEList();
        retval.addAll(list);
        list.clear();
        this.log.info((Object)("Returning HEList, size=" + retval.size()));
        return retval;
    }
}

