/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.he;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.ferris.astronomy.data.ServicesBySql;
import org.ferris.astronomy.data.he.HEFactory;
import org.ferris.astronomy.data.he.HEList;
import org.ferris.astronomy.data.he.HEServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.lang.Code;
import org.ferris.sql.ConnectionFactory;
import org.ferris.sql.ConnectionTools;

public class HEServicesBySql
extends ServicesBySql
implements HEServices {
    public HEServicesBySql(ConnectionFactory factory) {
        super(factory);
    }

    public HEList findByFrequency(double freqMin, double freqMax) throws AstronomyException {
        HEList hEList;
        StringBuffer sp = new StringBuffer("select frequency_mhz, name from he ");
        sp.append(" where ");
        sp.append(" frequency_mhz between ").append(freqMin).append(" and ").append(freqMax);
        sp.append(" order by frequency_mhz asc ");
        String sql = sp.toString();
        sp.setLength(0);
        sp = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            HEList list = new HEList();
            while (rs.next()) {
                list.add(HEFactory.getHE(rs));
            }
            hEList = list;
        }
        catch (Throwable t) {
            try {
                throw new AstronomyException(Code.ASTR000052, t, sql);
            }
            catch (Throwable throwable) {
                ConnectionTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        ConnectionTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return hEList;
    }
}

