/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.linelist;

import java.io.InputStream;
import java.util.List;
import org.ferris.astronomy.data.linelist.LineList;
import org.ferris.astronomy.data.linelist.LineListFactory;
import org.ferris.astronomy.io.LineNumberReaderWithErrorChecking;
import org.ferris.astronomy.net.runner.HttpResponseHandlerForPlainText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LineListResponseHandler
extends HttpResponseHandlerForPlainText<LineList> {
    LineListResponseHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LineList> response(InputStream response) {
        List<LineList> retval = super.response(response);
        LineNumberReaderWithErrorChecking reader = this.getLineNumberReaderWithErrorChecking();
        try {
            String line = reader.getLine();
            while (line != null) {
                retval.add(LineListFactory.getLineList(line, line));
                line = reader.getLine();
            }
            List<LineList> list = retval;
            return list;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable ignore) {}
            }
        }
    }
}

