/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.linelist;

import java.util.List;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.linelist.LineListList;
import org.ferris.astronomy.data.linelist.LineListResponseHandler;
import org.ferris.astronomy.data.linelist.LineListServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.net.runner.HttpRequestRunnerForLineListServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineListServicesByPhp
implements LineListServices {
    private static String PAGE = "get.linelists.php";
    protected Logger log = Logger.getLogger(this.getClass());

    private final String getParameter(List<String> lineListIds) {
        if (lineListIds == null || lineListIds.size() == 0) {
            return "";
        }
        StringBuilder sp = new StringBuilder();
        for (String string : lineListIds) {
            if (string == null || (string = string.trim()).length() == 0) continue;
            if (sp.length() > 0) {
                sp.append(",");
            }
            sp.append(string);
        }
        return sp.toString();
    }

    @Override
    public LineListList findAll() throws AstronomyException {
        this.log.info((Object)"Enter: findAll()");
        this.log.info((Object)"Creating runner <LineList>");
        HttpRequestRunnerForLineListServices runner = new HttpRequestRunnerForLineListServices(PAGE);
        this.log.info((Object)"Building query");
        StringBuilder query = new StringBuilder();
        query.append(runner.getResource());
        this.log.info((Object)("Query: " + query.toString()));
        this.log.info((Object)"Setting query parameters");
        this.log.info((Object)"Running query");
        List list = runner.get(query.toString(), new LineListResponseHandler());
        this.log.info((Object)"Creating LineListList");
        LineListList retval = null;
        retval = new LineListList();
        retval.addAll(list);
        list.clear();
        this.log.info((Object)("Returning LineListList, size=" + retval.size()));
        return retval;
    }

    @Override
    public LineListList findByLineLists(List<String> lineListIds) throws AstronomyException {
        this.log.info((Object)("Enter: findByLineLists(" + lineListIds + ")"));
        this.log.info((Object)"Creating runner <LineList>");
        HttpRequestRunnerForLineListServices runner = new HttpRequestRunnerForLineListServices(PAGE);
        this.log.info((Object)"Building query");
        StringBuilder query = new StringBuilder();
        query.append(runner.getResource());
        query.append("?");
        query.append("lineListIdList").append("=").append("?");
        this.log.info((Object)("Query: " + query.toString()));
        this.log.info((Object)"Setting query parameters");
        runner.addParameter(this.getParameter(lineListIds));
        this.log.info((Object)"Running query");
        List list = runner.get(query.toString(), new LineListResponseHandler());
        this.log.info((Object)"Creating LineListList");
        LineListList retval = null;
        retval = new LineListList();
        retval.addAll(list);
        list.clear();
        this.log.info((Object)("Returning LineListList, size=" + retval.size()));
        return retval;
    }
}

