/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.linelist;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.ferris.astronomy.data.linelist.LineListFactory;
import org.ferris.astronomy.data.linelist.LineListList;
import org.ferris.astronomy.data.linelist.LineListServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.lang.Code;
import org.ferris.sql.ConnectionFactory;
import org.ferris.sql.ConnectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineListServicesBySql
implements LineListServices {
    private ConnectionFactory factory;

    public LineListServicesBySql(ConnectionFactory factory) {
        this.factory = factory;
    }

    public Connection getConnection() throws SQLException {
        return this.factory.getConnection();
    }

    private LineListList buildList(ResultSet rs) throws Throwable {
        LineListList list = new LineListList();
        while (rs.next()) {
            list.add(LineListFactory.getLineList(rs));
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LineListList findAll() throws AstronomyException {
        LineListList lineListList;
        String sql = "select distinct(linelist) id, linelist from catalog order by linelist";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            lineListList = this.buildList(rs);
        }
        catch (AstronomyException e) {
            try {
                throw e;
                catch (Throwable t) {
                    throw new AstronomyException(Code.ASTR000051, t, sql);
                }
            }
            catch (Throwable throwable) {
                ConnectionTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        ConnectionTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return lineListList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LineListList findByLineLists(List<String> lineListIds) throws AstronomyException {
        LineListList x2222222;
        String sql = "select distinct(linelist) id, linelist from catalog ";
        if (lineListIds != null && lineListIds.size() > 0) {
            String where = "";
            for (String id : lineListIds) {
                if (id == null || (id = id.trim()).length() == 0) continue;
                if (where.length() > 0) {
                    where = where + " or ";
                }
                where = where + " linelist=? ";
            }
            if (where.length() > 0) {
                sql = sql + "where ( " + where + " ) ";
            }
        }
        sql = sql + " order by linelist";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            if (lineListIds != null && lineListIds.size() > 0) {
                int x2222222 = 0;
                for (String id : lineListIds) {
                    if (id == null || (id = id.trim()).length() == 0) continue;
                    stmt.setString(++x2222222, id);
                }
            }
            rs = stmt.executeQuery();
            x2222222 = this.buildList(rs);
        }
        catch (AstronomyException e) {
            try {
                throw e;
                catch (Throwable t) {
                    throw new AstronomyException(Code.ASTR000051, t, sql);
                }
            }
            catch (Throwable throwable) {
                ConnectionTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        ConnectionTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return x2222222;
    }
}

