/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.molecule;

import org.apache.log4j.Logger;
import org.ferris.astronomy.data.molecule.Molecule;
import org.ferris.astronomy.data.molecule.MoleculeBean;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.util.split.StringSplitterDecorator;
import org.ferris.dom.NodeAdaptor;

public class MoleculeFactory {
    private static Logger log = Logger.getLogger(MoleculeFactory.class);

    public static Molecule getMolecule(int lineNumber, String tabDelimitedData) throws AstronomyException {
        log.debug((Object)"Enter: getMoleculeInstance(lineNumber, tabDelimitedData)");
        log.debug((Object)("Line# " + lineNumber));
        log.debug((Object)("Line: \"" + tabDelimitedData + "\""));
        StringSplitterDecorator tokens = new StringSplitterDecorator(tabDelimitedData, '\t');
        MoleculeBean bean = new MoleculeBean();
        bean.setId(tokens.getString("ID"));
        bean.setName(tokens.getString("NAME"));
        bean.setDescription(tokens.getString("DESCRIPTION"));
        bean.setSplatId(tokens.getString("SPLAT_ID"));
        return bean;
    }

    public static Molecule getMolecule(NodeAdaptor moleculeNode) {
        log.debug((Object)"Enter: getMoleculeInstance(NodeAdaptor)");
        MoleculeBean bean = new MoleculeBean();
        bean.setId(moleculeNode.getNodeAdaptor("id").getValue());
        bean.setName(moleculeNode.getNodeAdaptor("name").getNodeAdaptor("text").getValue());
        bean.setDescription(moleculeNode.getNodeAdaptor("name").getNodeAdaptor("html").getValue());
        bean.setSplatId(moleculeNode.getNodeAdaptor("splat-id").getValue());
        return bean;
    }
}

