/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.slaim;

import java.text.ParseException;
import org.ferris.astronomy.data.slaim.ColumnParser;
import org.ferris.astronomy.data.slaim.LineToParse;

public abstract class AbstractColumnParser
implements ColumnParser {
    protected LineToParse parser;
    private String chunk;

    public AbstractColumnParser(LineToParse parser, boolean checkChunkNullable) throws ParseException {
        this.parser = parser;
        this.checkLineLength();
        this.setChunk();
        this.checkChunk(checkChunkNullable);
    }

    public void checkLineLength() throws ParseException {
        if (this.parser.getLine().length() < this.getUpper()) {
            throw this.parser.getParseException(this.getColumnName() + ": Line length is less than " + this.getUpper());
        }
    }

    protected void setChunk() throws ParseException {
        this.chunk = this.parser.getLine().substring(this.getLower(), this.getUpper()).trim();
    }

    protected String toggleChunk(String newChunk) {
        String oldChunk = this.chunk;
        this.chunk = newChunk;
        return oldChunk;
    }

    public void checkChunk(boolean checkChunkNullable) throws ParseException {
        if (checkChunkNullable && this.getChunk().length() == 0) {
            throw this.parser.getParseException(this.getColumnName() + ": Trimmed to null.");
        }
    }

    public String getChunk() {
        return this.chunk;
    }

    public String getChunkSubstringTrimmed(char upToNotIncluding) {
        return this.chunk.substring(0, this.chunk.indexOf(upToNotIncluding)).trim();
    }

    public String getChunkSubstringTrimmed(char afterAndNotIncluding, char beforeAndNotIncluding) {
        int startAt = this.chunk.indexOf(afterAndNotIncluding) + 1;
        int endAt = this.chunk.indexOf(beforeAndNotIncluding, startAt);
        return this.chunk.substring(startAt, endAt).trim();
    }
}

