/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.slaim;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.regex.Pattern;
import org.ferris.astronomy.data.slaim.AbstractColumnParser;
import org.ferris.astronomy.data.slaim.LineToParse;
import org.ferris.astronomy.math.BigDecimalTools;

public class EnergyLevelParser
extends AbstractColumnParser {
    private BigDecimal energy;

    public int getLower() {
        return 51;
    }

    public int getUpper() {
        return 59;
    }

    public String getColumnName() {
        return "Energy Level";
    }

    public EnergyLevelParser(LineToParse parser) throws ParseException {
        super(parser, false);
        if (Pattern.matches("(-?\\d+)?\\.?\\d+", this.getChunk())) {
            this.setEnergyLevel(this.getChunk());
        } else if (!Pattern.matches("", this.getChunk())) {
            throw parser.getParseException(this.getColumnName() + ": Unknown pattern.", this.getChunk());
        }
    }

    public BigDecimal getEnergyLevel() {
        return this.energy;
    }

    private void setEnergyLevel(String convertToDouble) throws ParseException {
        try {
            this.energy = BigDecimalTools.getBigDecimal(convertToDouble);
        }
        catch (Exception e) {
            throw this.parser.getParseException(this.getColumnName() + ": NaN.", convertToDouble);
        }
    }
}

