/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.slaim;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.regex.Pattern;
import org.ferris.astronomy.data.slaim.AbstractColumnParser;
import org.ferris.astronomy.data.slaim.LineToParse;
import org.ferris.astronomy.math.BigDecimalTools;

public class LineStrengthParser
extends AbstractColumnParser {
    private BigDecimal lineStrength;

    public int getLower() {
        return 115;
    }

    public int getUpper() {
        return 122;
    }

    public String getColumnName() {
        return "Line Strength (Sij)";
    }

    public LineStrengthParser(LineToParse parser) throws ParseException {
        super(parser, false);
        if (!Pattern.matches("", this.getChunk())) {
            if (Pattern.matches("\\d*?\\.\\d+(E-\\d)?", this.getChunk())) {
                this.setLineStrength(this.getChunk());
            } else {
                throw parser.getParseException(this.getColumnName() + ": Unknown pattern.", this.getChunk());
            }
        }
    }

    public BigDecimal getLineStrength() {
        return this.lineStrength;
    }

    private void setLineStrength(String shouldBeADouble) throws ParseException {
        try {
            this.lineStrength = BigDecimalTools.getBigDecimal(shouldBeADouble);
        }
        catch (Exception e) {
            throw this.parser.getParseException(this.getColumnName(), this.getChunk());
        }
    }
}

