/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.slaim;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.regex.Pattern;
import org.ferris.astronomy.data.slaim.AbstractColumnParser;
import org.ferris.astronomy.data.slaim.LineToParse;
import org.ferris.astronomy.math.BigDecimalTools;

public class MeasuredFrequencyParser
extends AbstractColumnParser {
    private BigDecimal freq;
    private BigDecimal err;

    public int getLower() {
        return 33;
    }

    public int getUpper() {
        return 51;
    }

    public String getColumnName() {
        return "Measured Frequency";
    }

    public MeasuredFrequencyParser(LineToParse parser) throws ParseException {
        super(parser, false);
        if (Pattern.matches("\\d+\\.\\d+(\\s{0,2})?\\((\\s+)?\\d+\\s*\\)", this.getChunk())) {
            this.setFrequency('(');
            this.setError('(', ')');
        } else if (Pattern.matches("\\d+\\.\\d*\\s*\\(\\s+\\)", this.getChunk())) {
            this.setFrequency('(');
        } else if (Pattern.matches("\\d+\\.\\d+\\s*\\(\\*\\s*\\d+\\)", this.getChunk())) {
            this.setFrequency('(');
            this.setError('*', ')');
        } else if (!Pattern.matches("", this.getChunk())) {
            if (Pattern.matches("\\d+\\.\\d+", this.getChunk())) {
                this.setFrequency(this.getChunk());
            } else {
                throw parser.getParseException(this.getColumnName() + ": Unknown pattern.", this.getChunk());
            }
        }
    }

    public BigDecimal getFrequency() {
        return this.freq;
    }

    private void setFrequency(char upToButNotIncluding) throws ParseException {
        try {
            this.freq = BigDecimalTools.getBigDecimal(this.getChunkSubstringTrimmed(upToButNotIncluding));
        }
        catch (Exception e) {
            throw this.parser.getParseException(this.getColumnName() + ": Freq NaN.", this.getChunkSubstringTrimmed(upToButNotIncluding));
        }
    }

    private void setFrequency(String convertToDouble) throws ParseException {
        try {
            this.freq = BigDecimalTools.getBigDecimal(convertToDouble);
        }
        catch (Exception e) {
            throw this.parser.getParseException(this.getColumnName() + ": Freq NaN.", convertToDouble);
        }
    }

    public BigDecimal getError() {
        return this.err;
    }

    private void setError(char afterButNotIncluding, char upToButNotIncluding) throws ParseException {
        try {
            this.err = BigDecimalTools.getBigDecimal(this.getChunkSubstringTrimmed(afterButNotIncluding, upToButNotIncluding));
        }
        catch (Exception e) {
            throw this.parser.getParseException(this.getColumnName() + ": Freq Err NaN.", this.getChunkSubstringTrimmed(afterButNotIncluding, upToButNotIncluding));
        }
    }
}

