/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.slaim;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.regex.Pattern;
import org.ferris.astronomy.data.slaim.AbstractColumnParser;
import org.ferris.astronomy.data.slaim.LineToParse;
import org.ferris.astronomy.math.BigDecimalTools;

public class QuantumNumbersParser
extends AbstractColumnParser {
    private static final int INDEX_OF_DASH_SEPARATING_HI_AND_LOW_QUANTUM_NUMBERS = 71;
    private String leftChunk;
    private String rightChunk;
    private int indexOfDashSeparatingHiAndLowQuantumNumbers;
    private BigDecimal jUp;
    private BigDecimal kaUp;
    private BigDecimal kcUp;
    private BigDecimal jLow;
    private BigDecimal kaLow;
    private BigDecimal kcLow;

    public int getLower() {
        return 60;
    }

    public int getUpper() {
        return 109;
    }

    public String getColumnName() {
        return "Quantum Numbers";
    }

    protected void setChunk() throws ParseException {
        super.setChunk();
        this.setIndexOfDashSeparatingHiAndLowQuantumNumbers(71);
        this.setLeftChunk();
        this.setRightChunk();
    }

    protected int setIndexOfDashSeparatingHiAndLowQuantumNumbers(int tryIndex) throws ParseException {
        if (tryIndex == 73) {
            throw this.parser.getParseException("At index 71 of this line I'm suppose to find the '-' character representing  the separation between hi and low quantum numbers but instead  I found the character '" + this.parser.getLine().charAt(71) + "'");
        }
        char c = this.parser.getLine().charAt(tryIndex);
        if (c == '-') {
            this.indexOfDashSeparatingHiAndLowQuantumNumbers = tryIndex;
            return tryIndex;
        }
        return this.setIndexOfDashSeparatingHiAndLowQuantumNumbers(++tryIndex);
    }

    private int getIndexOfDashSeparatingHiAndLowQuantumNumbers() {
        return this.indexOfDashSeparatingHiAndLowQuantumNumbers;
    }

    protected void setLeftChunk() throws ParseException {
        try {
            this.leftChunk = this.parser.getLine().substring(this.getLower(), this.getIndexOfDashSeparatingHiAndLowQuantumNumbers()).trim();
        }
        catch (Exception e) {
            throw this.parser.getParseException(e.getMessage() + " idx = '" + this.getIndexOfDashSeparatingHiAndLowQuantumNumbers() + "'");
        }
    }

    protected void setRightChunk() throws ParseException {
        try {
            this.rightChunk = this.parser.getLine().substring(this.getIndexOfDashSeparatingHiAndLowQuantumNumbers() + 1, this.getUpper()).trim();
        }
        catch (Exception e) {
            throw this.parser.getParseException(e.getMessage() + " idx = '" + this.getIndexOfDashSeparatingHiAndLowQuantumNumbers() + "'");
        }
    }

    private String getLeftChunkSubstringTrimmed(char upToButNotIncluding) {
        String oldChunk = this.toggleChunk(this.leftChunk);
        String retval = this.getChunkSubstringTrimmed(upToButNotIncluding);
        this.toggleChunk(oldChunk);
        return retval;
    }

    private String getRightChunkSubstringTrimmed(char upToButNotIncluding) {
        String oldChunk = this.toggleChunk(this.rightChunk);
        String retval = this.getChunkSubstringTrimmed(upToButNotIncluding);
        this.toggleChunk(oldChunk);
        return retval;
    }

    private String getLeftChunkSubstringTrimmed(char afterAndNotIncluding, char beforeAndNotIncluding) {
        String oldChunk = this.toggleChunk(this.leftChunk);
        String retval = this.getChunkSubstringTrimmed(afterAndNotIncluding, beforeAndNotIncluding);
        this.toggleChunk(oldChunk);
        return retval;
    }

    private String getRightChunkSubstringTrimmed(char afterAndNotIncluding, char beforeAndNotIncluding) {
        String oldChunk = this.toggleChunk(this.rightChunk);
        String retval = this.getChunkSubstringTrimmed(afterAndNotIncluding, beforeAndNotIncluding);
        this.toggleChunk(oldChunk);
        return retval;
    }

    public QuantumNumbersParser(LineToParse parser) throws ParseException {
        super(parser, false);
        if (Pattern.matches("\\d+\\(\\s*-?\\d+,\\s*-?\\d+\\)-\\s+\\d+\\(\\s*-?\\d+,\\s*-?\\d+\\).*", this.getChunk())) {
            this.setJUp('(');
            this.setKaUp('(', ',');
            this.setKcUp(',', ')');
            this.setJLow('(');
            this.setKaLow('(', ',');
            this.setKcLow(',', ')');
        } else if (Pattern.matches("\\d+\\s*\\(\\s*[-\\+]?\\d+\\s*\\)\\s*-\\s+\\d+\\s*\\(\\s*[-\\+]?\\d+\\s*\\).*", this.getChunk())) {
            this.setJUp('(');
            this.setKaUp('(', ')');
            this.setJLow('(');
            this.setKaLow('(', ')');
        } else if (Pattern.matches("\\d+,\\s\\d+[a-z]\\s+-\\s+\\d+,\\s\\d+[a-z].*", this.getChunk())) {
            this.setJUp(',');
            this.setJLow(',');
        } else if (Pattern.matches("(\\d*\\.)?\\d+\\s*,\\s+\\d+\\s+-\\s+(\\d*\\.)?\\d+\\s*,\\s+\\d+.*", this.getChunk())) {
            this.setJUp(',');
            this.setJLow(',');
        } else if (Pattern.matches("(\\d*\\.)?\\d+\\s+\\d+\\s+-\\s+(\\d*\\.)?\\d+\\s+\\d+.*", this.getChunk())) {
            this.setJUp(' ');
            this.setJLow(' ');
        } else if (Pattern.matches("\\d+\\.\\s\\d+\\s+-\\s+\\d+\\.\\s\\d+.*", this.getChunk())) {
            this.setJUp(this.leftChunk.replaceAll("\\s+", ""));
            String parsed = this.rightChunk.replaceFirst("\\s+", "");
            parsed = parsed.substring(0, parsed.indexOf(32));
            this.setJLow(parsed);
        } else if (Pattern.matches("\\d+\\s+-\\s+\\d+.*", this.getChunk())) {
            this.setJUp(this.leftChunk);
            int idx = this.rightChunk.indexOf(32);
            this.setJLow(idx < 0 ? this.rightChunk : this.rightChunk.substring(0, idx));
        } else if (Pattern.matches("\\d+\\.\\d+\\s+-\\s+\\d+\\.\\d+.*", this.getChunk())) {
            this.setJUp(this.leftChunk);
            int idx = this.rightChunk.indexOf(32);
            this.setJLow(idx < 0 ? this.rightChunk : this.rightChunk.substring(0, idx));
        } else {
            throw parser.getParseException(this.getColumnName() + ": Unknown pattern.", this.getChunk());
        }
    }

    public BigDecimal getJUp() {
        return this.jUp;
    }

    private void setJUp(char upToButNotIncluding) throws ParseException {
        String field = "JUp Problem";
        try {
            this.jUp = BigDecimalTools.getBigDecimal(this.getLeftChunkSubstringTrimmed(upToButNotIncluding));
        }
        catch (Exception e) {
            throw this.parser.getParseException(this.getColumnName() + ": " + field + ".", this.getChunk());
        }
    }

    private void setJUp(String shouldBeADouble) throws ParseException {
        String field = "JUp Problem";
        try {
            this.jUp = BigDecimalTools.getBigDecimal(shouldBeADouble);
        }
        catch (Exception e) {
            throw this.parser.getParseException(this.getColumnName() + ": " + field + ".", this.getChunk());
        }
    }

    public BigDecimal getKaUp() {
        return this.kaUp;
    }

    private void setKaUp(char afterAndNotIncluding, char beforeAndNotIncluding) throws ParseException {
        String field = "KaUp Problem";
        try {
            this.kaUp = BigDecimalTools.getBigDecimal(this.getLeftChunkSubstringTrimmed(afterAndNotIncluding, beforeAndNotIncluding));
        }
        catch (Exception e) {
            throw this.parser.getParseException(this.getColumnName() + ": " + field + ".", this.getChunk());
        }
    }

    public BigDecimal getKcUp() {
        return this.kcUp;
    }

    private void setKcUp(char afterAndNotIncluding, char beforeAndNotIncluding) throws ParseException {
        String field = "KcUp Problem";
        try {
            this.kcUp = BigDecimalTools.getBigDecimal(this.getLeftChunkSubstringTrimmed(afterAndNotIncluding, beforeAndNotIncluding));
        }
        catch (Exception e) {
            throw this.parser.getParseException(this.getColumnName() + ": " + field + ".", this.getChunk());
        }
    }

    public BigDecimal getJLow() {
        return this.jLow;
    }

    private void setJLow(char upToButNotIncluding) throws ParseException {
        String field = "JLow Problem";
        try {
            this.jLow = BigDecimalTools.getBigDecimal(this.getRightChunkSubstringTrimmed(upToButNotIncluding));
        }
        catch (Exception e) {
            throw this.parser.getParseException(this.getColumnName() + ": " + field + ".", this.getChunk());
        }
    }

    private void setJLow(String shouldBeADouble) throws ParseException {
        String field = "JLow Problem";
        try {
            this.jLow = BigDecimalTools.getBigDecimal(shouldBeADouble);
        }
        catch (Exception e) {
            throw this.parser.getParseException(this.getColumnName() + ": " + field + ".", this.getChunk());
        }
    }

    public BigDecimal getKaLow() {
        return this.kaLow;
    }

    private void setKaLow(char afterAndNotIncluding, char beforeAndNotIncluding) throws ParseException {
        String field = "KaLow Problem";
        try {
            this.kaLow = BigDecimalTools.getBigDecimal(this.getRightChunkSubstringTrimmed(afterAndNotIncluding, beforeAndNotIncluding));
        }
        catch (Exception e) {
            throw this.parser.getParseException(this.getColumnName() + ": " + field + ".", this.getChunk());
        }
    }

    public BigDecimal getKcLow() {
        return this.kcLow;
    }

    private void setKcLow(char afterAndNotIncluding, char beforeAndNotIncluding) throws ParseException {
        String field = "KcLow Problem";
        try {
            this.kcLow = BigDecimalTools.getBigDecimal(this.getRightChunkSubstringTrimmed(afterAndNotIncluding, beforeAndNotIncluding));
        }
        catch (Exception e) {
            throw this.parser.getParseException(this.getColumnName() + ": " + field + ".", this.getChunk());
        }
    }
}

