/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.slaim;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.regex.Pattern;
import org.ferris.astronomy.data.slaim.AbstractColumnParser;
import org.ferris.astronomy.data.slaim.LineToParse;
import org.ferris.astronomy.math.BigDecimalTools;

public class RelativeIntensityParser
extends AbstractColumnParser {
    private BigDecimal relativeIntensity;

    public int getLower() {
        return 109;
    }

    public int getUpper() {
        return 115;
    }

    public String getColumnName() {
        return "Relative Intensity";
    }

    public RelativeIntensityParser(LineToParse parser) throws ParseException {
        super(parser, false);
        if (!Pattern.matches("", this.getChunk())) {
            if (Pattern.matches("\\d*?\\.?\\d+", this.getChunk())) {
                this.setRelativeIntensity(this.getChunk());
            } else {
                throw parser.getParseException(this.getColumnName() + ": Unknown pattern.", this.getChunk());
            }
        }
    }

    public BigDecimal getRelativeIntensity() {
        return this.relativeIntensity;
    }

    private void setRelativeIntensity(String shouldBeADouble) throws ParseException {
        try {
            this.relativeIntensity = BigDecimalTools.getBigDecimal(shouldBeADouble);
        }
        catch (Exception e) {
            throw this.parser.getParseException(this.getColumnName(), this.getChunk());
        }
    }
}

