/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.slaim;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.ferris.astronomy.data.slaim.AbstractColumnParser;
import org.ferris.astronomy.data.slaim.CalculatedFrequencyParser;
import org.ferris.astronomy.data.slaim.EnergyLevelParser;
import org.ferris.astronomy.data.slaim.LineStrengthParser;
import org.ferris.astronomy.data.slaim.LineToParse;
import org.ferris.astronomy.data.slaim.MeasuredFrequencyParser;
import org.ferris.astronomy.data.slaim.MoleculeNameParser;
import org.ferris.astronomy.data.slaim.QuantumNumbersParser;
import org.ferris.astronomy.data.slaim.ReferenceParser;
import org.ferris.astronomy.data.slaim.RelativeIntensityParser;
import org.ferris.astronomy.data.slaim.SlaimServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.lang.Code;
import org.ferris.sql.ConnectionTools;

public class SlaimServicesBySql
implements SlaimServices {
    private Connection conn;

    public SlaimServicesBySql(Connection conn) {
        this.conn = conn;
    }

    protected Connection getConnection() throws AstronomyException {
        return this.conn;
    }

    protected void set(int idx, PreparedStatement stmt, String value) throws SQLException {
        if (value == null) {
            stmt.setNull(idx, 12);
        } else {
            stmt.setString(idx, value);
        }
    }

    protected void set(int idx, PreparedStatement stmt, BigDecimal value) throws SQLException {
        if (value == null) {
            stmt.setNull(idx, 8);
        } else {
            stmt.setDouble(idx, value.doubleValue());
        }
    }

    protected void set(int idx, PreparedStatement stmt, double value) throws SQLException {
        if (Double.isNaN(value)) {
            stmt.setNull(idx, 8);
        } else if (Double.isInfinite(value)) {
            stmt.setNull(idx, 8);
        } else {
            stmt.setDouble(idx, value);
        }
    }

    public void insert(LineToParse ltp) throws AstronomyException {
        String sql = "insert into catalog  (molecule, calculated_freq_asString, calculated_freq, calculated_freq_err,  measured_freq_asString, measured_freq, measured_freq_err,  energy_level,  quantum_number, j_up, ka_up, kc_up, j_low, ka_low, kc_low,  relative_intensity_hfs, line_strength_sij, slaim_ref, linelist) values  (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;
        try {
            stmt = this.getConnection().prepareStatement(sql);
            int x = 0;
            AbstractColumnParser p = new MoleculeNameParser(ltp);
            this.set(++x, stmt, ((MoleculeNameParser)p).getName());
            p = new CalculatedFrequencyParser(ltp);
            this.set(++x, stmt, p.getChunk());
            this.set(++x, stmt, ((CalculatedFrequencyParser)p).getFrequency());
            this.set(++x, stmt, ((CalculatedFrequencyParser)p).getError());
            p = new MeasuredFrequencyParser(ltp);
            this.set(++x, stmt, p.getChunk());
            this.set(++x, stmt, ((MeasuredFrequencyParser)p).getFrequency());
            this.set(++x, stmt, ((MeasuredFrequencyParser)p).getError());
            p = new EnergyLevelParser(ltp);
            this.set(++x, stmt, ((EnergyLevelParser)p).getEnergyLevel());
            p = new QuantumNumbersParser(ltp);
            this.set(++x, stmt, p.getChunk());
            this.set(++x, stmt, ((QuantumNumbersParser)p).getJUp());
            this.set(++x, stmt, ((QuantumNumbersParser)p).getKaUp());
            this.set(++x, stmt, ((QuantumNumbersParser)p).getKcUp());
            this.set(++x, stmt, ((QuantumNumbersParser)p).getJLow());
            this.set(++x, stmt, ((QuantumNumbersParser)p).getKaLow());
            this.set(++x, stmt, ((QuantumNumbersParser)p).getKcLow());
            p = new RelativeIntensityParser(ltp);
            this.set(++x, stmt, ((RelativeIntensityParser)p).getRelativeIntensity());
            p = new LineStrengthParser(ltp);
            this.set(++x, stmt, ((LineStrengthParser)p).getLineStrength());
            p = new ReferenceParser(ltp);
            this.set(++x, stmt, ((ReferenceParser)p).getReference());
            this.set(++x, stmt, "SLAIM");
            stmt.executeUpdate();
        }
        catch (Throwable t) {
            try {
                throw new AstronomyException(Code.ASTR000051, t, sql);
            }
            catch (Throwable throwable) {
                ConnectionTools.close(stmt);
                throw throwable;
            }
        }
        ConnectionTools.close((Statement)stmt);
    }

    public void truncate() throws AstronomyException {
        String sql = "truncate table catalog";
        PreparedStatement stmt = null;
        try {
            stmt = this.getConnection().prepareStatement(sql);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new AstronomyException(Code.ASTR000051, (Throwable)e, sql);
            }
            catch (Throwable throwable) {
                ConnectionTools.close(stmt);
                throw throwable;
            }
        }
        ConnectionTools.close((Statement)stmt);
    }
}

