/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.source;

import java.math.BigDecimal;
import org.ferris.astronomy.data.source.Source;
import org.ferris.astronomy.data.telescope.Telescope;
import org.ferris.astronomy.math.BigDecimalTools;

public class SourceBean
implements Source {
    protected String id;
    protected String intensityUnits;
    protected String name;
    protected Telescope telescope;
    protected BigDecimal velocityKmSec;
    protected BigDecimal frequencyMultiplier;

    protected SourceBean setId(String id) {
        this.id = id;
        return this;
    }

    protected SourceBean setIntensityUnits(String intensityUnits) {
        this.intensityUnits = intensityUnits;
        return this;
    }

    protected SourceBean setName(String name) {
        this.name = name;
        return this;
    }

    protected SourceBean setTelescope(Telescope telescope) {
        this.telescope = telescope;
        return this;
    }

    protected SourceBean setVelocityKmSec(BigDecimal velocityKmSec) {
        this.velocityKmSec = velocityKmSec;
        return this;
    }

    protected SourceBean setFrequencyMultiplier(double d) {
        this.frequencyMultiplier = BigDecimalTools.getBigDecimal(d);
        return this;
    }

    protected SourceBean() {
    }

    public String toString() {
        StringBuffer sp = new StringBuffer();
        sp.append("[SourceBean");
        sp.append(" id=").append(this.getId());
        sp.append(", intensityUnits=").append(this.getIntensityUnits());
        sp.append(", name=").append(this.getName());
        sp.append(", velocityKmSec=").append(this.getVelocityKmSec());
        sp.append(", telescope=").append(this.getTelescope());
        sp.append(", frequencyMultiplier=").append(this.getFrequencyMultiplier());
        sp.append("]");
        return sp.toString();
    }

    public String getId() {
        return this.id;
    }

    public String getIntensityUnits() {
        return this.intensityUnits;
    }

    public String getName() {
        return this.name;
    }

    public Telescope getTelescope() {
        return this.telescope;
    }

    public BigDecimal getVelocityKmSec() {
        return this.velocityKmSec;
    }

    public BigDecimal getFrequencyMultiplier() {
        return this.frequencyMultiplier;
    }

    public BigDecimal getCalculatedVelocity(double userVelocity, double centerFrequency) {
        return BigDecimalTools.getBigDecimal((this.getVelocityKmSec().doubleValue() - userVelocity) / (3.0 * Math.pow(10.0, 5.0)) * centerFrequency + centerFrequency);
    }
}

