/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.source;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.source.Source;
import org.ferris.astronomy.data.source.SourceBean;
import org.ferris.astronomy.data.source.SourceFactoryDefault;
import org.ferris.astronomy.data.telescope.Telescope;
import org.ferris.astronomy.data.telescope.TelescopeFactory;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.astronomy.util.split.StringSplitterDecorator;

public abstract class SourceFactory {
    private static Logger log = Logger.getLogger(SourceFactory.class);
    private static SourceFactory instance = null;

    private static SourceFactory getInstance() {
        if (instance == null) {
            log.info((Object)"Determine SourceFactory instance");
            String fullyQualifiedClassName = System.getProperty("org.ferris.astronomy.data.source.SourceFactory");
            log.info((Object)("fullyQualifiedClassName: " + fullyQualifiedClassName));
            if (fullyQualifiedClassName == null) {
                instance = new SourceFactoryDefault();
            } else {
                try {
                    Object o = Class.forName(fullyQualifiedClassName).newInstance();
                    if (SourceFactory.class.isAssignableFrom(o.getClass())) {
                        instance = (SourceFactory)o;
                        log.info((Object)("Created instance: " + fullyQualifiedClassName));
                    }
                }
                catch (Throwable t) {
                    log.warn((Object)("The class name \"" + fullyQualifiedClassName + "\" is not found in the class path."), t);
                }
                if (instance == null) {
                    instance = new SourceFactoryDefault();
                }
            }
        }
        return instance;
    }

    public static Source getSource(String id, String name, String intensityUnits, BigDecimal velocityKmSec, Telescope telescope, double frequencyMultiplier) {
        return SourceFactory.getInstance().getSourceInstance(id, name, intensityUnits, velocityKmSec, telescope, frequencyMultiplier);
    }

    protected Source getSourceInstance(String id, String name, String intensityUnits, BigDecimal velocityKmSec, Telescope telescope, double frequencyMultiplier) {
        log.debug((Object)("Enter: getSourceInstance(" + id + "," + name + "," + intensityUnits + "," + velocityKmSec + "," + telescope + "," + frequencyMultiplier + ")"));
        SourceBean bean = this.getSourceBean();
        bean.setFrequencyMultiplier(frequencyMultiplier);
        bean.setId(id);
        bean.setIntensityUnits(intensityUnits);
        bean.setName(name);
        bean.setTelescope(telescope);
        bean.setVelocityKmSec(velocityKmSec);
        return bean;
    }

    public static Source getSource(ResultSet resultSet) throws SQLException {
        return SourceFactory.getInstance().getSourceInstance(resultSet);
    }

    protected Source getSourceInstance(ResultSet resultSet) throws SQLException {
        log.debug((Object)("Enter: getSourceInstance(" + resultSet + ")"));
        return SourceFactory.getSource(resultSet.getString("id"), resultSet.getString("source"), resultSet.getString("intensity_units"), BigDecimalTools.getBigDecimal(resultSet.getDouble("vlsr_km_sec")), TelescopeFactory.getTelescope(resultSet.getString("telescope")), 1.0);
    }

    public static Source getSource(int lineNumber, String delimitedData, char deliminator) {
        return SourceFactory.getInstance().getSourceInstance(lineNumber, delimitedData, deliminator);
    }

    public Source getSourceInstance(int lineNumber, String delimitedData, char deliminator) {
        log.debug((Object)("Enter: getSourceInstance(" + lineNumber + ", " + delimitedData + ", " + deliminator + ")"));
        StringSplitterDecorator tokens = new StringSplitterDecorator(delimitedData, deliminator);
        String id = tokens.getString("id");
        String name = tokens.getString("source");
        BigDecimal velocity = tokens.getBigDecimal("vlsr_km_sec");
        Telescope t = TelescopeFactory.getTelescope(tokens.getString("telescope"));
        String intensity = tokens.getString("intensity_units");
        return SourceFactory.getSource(id, name, intensity, velocity, t, 1.0);
    }

    protected SourceBean getSourceBean() {
        return new SourceBean();
    }
}

