/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.source;

import java.util.List;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.source.SourceList;
import org.ferris.astronomy.data.source.SourceResponseHandler;
import org.ferris.astronomy.data.source.SourceServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.net.runner.HttpRequestRunnerForLineListServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceServicesByPhp
implements SourceServices {
    private static String PAGE = "get.source.php";
    protected Logger log = Logger.getLogger(this.getClass());

    private final String getParameter(List<String> clientIds) {
        if (clientIds == null || clientIds.size() == 0) {
            return "";
        }
        StringBuilder sp = new StringBuilder();
        for (String string : clientIds) {
            if (string == null || (string = string.trim()).length() == 0) continue;
            if (sp.length() > 0) {
                sp.append(",");
            }
            sp.append(string);
        }
        return sp.toString();
    }

    @Override
    public SourceList findAll() throws AstronomyException {
        this.log.info((Object)"Enter: findAll()");
        this.log.info((Object)"Creating runner <Source>");
        HttpRequestRunnerForLineListServices runner = new HttpRequestRunnerForLineListServices(PAGE);
        this.log.info((Object)"Building query");
        StringBuilder query = new StringBuilder();
        query.append(runner.getResource());
        this.log.info((Object)("Query: " + query.toString()));
        this.log.info((Object)"Setting query parameters");
        this.log.info((Object)"Running query");
        List list = runner.get(query.toString(), new SourceResponseHandler());
        this.log.info((Object)"Creating SourceList");
        SourceList retval = null;
        retval = new SourceList();
        retval.addAll(list);
        list.clear();
        this.log.info((Object)("Returning SourceList, size=" + retval.size()));
        return retval;
    }

    @Override
    public SourceList findByClient(List<String> clientIds) throws AstronomyException {
        this.log.info((Object)("Enter: findByClient(" + clientIds + ")"));
        this.log.info((Object)"Creating runner <Source>");
        HttpRequestRunnerForLineListServices runner = new HttpRequestRunnerForLineListServices(PAGE);
        this.log.info((Object)"Building query");
        StringBuilder query = new StringBuilder();
        query.append(runner.getResource());
        query.append("?");
        query.append("clientIdList").append("=").append("?");
        this.log.info((Object)("Query: " + query.toString()));
        this.log.info((Object)"Setting query parameters");
        runner.addParameter(this.getParameter(clientIds));
        this.log.info((Object)"Running query");
        List list = runner.get(query.toString(), new SourceResponseHandler());
        this.log.info((Object)"Creating SourceList");
        SourceList retval = null;
        retval = new SourceList();
        retval.addAll(list);
        list.clear();
        this.log.info((Object)("Returning SourceList, size=" + retval.size()));
        return retval;
    }
}

