/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.source;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.ferris.astronomy.data.ServicesBySql;
import org.ferris.astronomy.data.source.SourceFactory;
import org.ferris.astronomy.data.source.SourceList;
import org.ferris.astronomy.data.source.SourceServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.lang.Code;
import org.ferris.sql.ConnectionFactory;
import org.ferris.sql.ConnectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceServicesBySql
extends ServicesBySql
implements SourceServices {
    private final String getWhere(List<String> clientIds) {
        if (clientIds == null || clientIds.size() == 0) {
            return "";
        }
        StringBuilder sp = new StringBuilder();
        for (String string : clientIds) {
            if (string == null || (string = string.trim()).length() == 0) continue;
            if (sp.length() > 0) {
                sp.append(" or ");
            }
            sp.append(" client_id=? ");
        }
        return " and (" + sp.toString() + ") ";
    }

    private final void setString(PreparedStatement stmt, List<String> clientIds) throws SQLException {
        if (clientIds != null && clientIds.size() > 0) {
            int x = 0;
            for (String string : clientIds) {
                if (string == null || (string = string.trim()).length() == 0) continue;
                stmt.setString(x++, string);
            }
        }
    }

    public SourceServicesBySql(ConnectionFactory factory) {
        super(factory);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SourceList findAll() throws AstronomyException {
        SourceList sourceList;
        String sql = "select id, source, vlsr_km_sec, telescope, intensity_units from source order by source asc";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            SourceList list = new SourceList();
            while (rs.next()) {
                list.add(SourceFactory.getSource(rs));
            }
            sourceList = list;
        }
        catch (AstronomyException e) {
            try {
                throw e;
                catch (Throwable t) {
                    throw new AstronomyException(Code.ASTR000052, t, sql);
                }
            }
            catch (Throwable throwable) {
                ConnectionTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        ConnectionTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return sourceList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SourceList findByClient(List<String> clientIds) throws AstronomyException {
        SourceList sourceList;
        String sql = "select id, source, vlsr_km_sec, telescope, intensity_units from source where 1=1 ";
        sql = sql + this.getWhere(clientIds);
        sql = sql + " order by source asc ";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            this.setString(stmt, clientIds);
            rs = stmt.executeQuery();
            SourceList list = new SourceList();
            while (rs.next()) {
                list.add(SourceFactory.getSource(rs));
            }
            sourceList = list;
        }
        catch (AstronomyException e) {
            try {
                throw e;
                catch (Throwable t) {
                    throw new AstronomyException(Code.ASTR000052, t, sql);
                }
            }
            catch (Throwable throwable) {
                ConnectionTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        ConnectionTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return sourceList;
    }
}

