/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.sourcedata;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.sourcedata.SourceData;
import org.ferris.astronomy.data.sourcedata.SourceDataBean;
import org.ferris.astronomy.data.sourcedata.SourceFactoryDefault;
import org.ferris.astronomy.util.split.StringSplitterDecorator;

public abstract class SourceDataFactory {
    private static Logger log = Logger.getLogger(SourceDataFactory.class);
    private static SourceDataFactory instance = null;

    private static SourceDataFactory getInstance() {
        if (instance == null) {
            log.info((Object)"Determine SourceDataFactory instance");
            String fullyQualifiedClassName = System.getProperty("org.ferris.astronomy.data.sourcedata.SourceDataFactory");
            log.info((Object)("fullyQualifiedClassName: " + fullyQualifiedClassName));
            if (fullyQualifiedClassName == null) {
                instance = new SourceFactoryDefault();
            } else {
                try {
                    Object o = Class.forName(fullyQualifiedClassName).newInstance();
                    if (SourceDataFactory.class.isAssignableFrom(o.getClass())) {
                        instance = (SourceDataFactory)o;
                        log.info((Object)("Created instance: " + fullyQualifiedClassName));
                    }
                }
                catch (Throwable t) {
                    log.warn((Object)("The class name \"" + fullyQualifiedClassName + "\" is not found in the class path."), t);
                }
                if (instance == null) {
                    instance = new SourceFactoryDefault();
                }
            }
        }
        return instance;
    }

    public static SourceData getSourceData(double frequencyMhz, double intensity, String band) {
        return SourceDataFactory.getInstance().getSourceDataInstance(frequencyMhz, intensity, band);
    }

    protected SourceData getSourceDataInstance(double frequencyMhz, double intensity, String band) {
        log.debug((Object)("Enter: getSourceDataInstance(" + frequencyMhz + "," + intensity + "," + band + ")"));
        SourceDataBean bean = this.getSourceDataBean();
        bean.setFrequency(frequencyMhz);
        bean.setIntensity(intensity);
        bean.setBand(band);
        return bean;
    }

    public static SourceData getSourceData(ResultSet resultSet) throws SQLException {
        return SourceDataFactory.getInstance().getSourceDataInstance(resultSet);
    }

    protected SourceData getSourceDataInstance(ResultSet resultSet) throws SQLException {
        log.debug((Object)("Enter: getSourceDataInstance(" + resultSet + ")"));
        return this.getSourceDataInstance(resultSet.getDouble("frequency_mhz"), resultSet.getDouble("intensity"), resultSet.getString("band"));
    }

    public static SourceData getSourceData(int lineNumber, String delimitedData, char deliminator) {
        return SourceDataFactory.getInstance().getSourceDataInstance(lineNumber, delimitedData, deliminator);
    }

    public SourceData getSourceDataInstance(int lineNumber, String delimitedData, char deliminator) {
        log.debug((Object)("Enter: getSourceDataInstance(" + lineNumber + ", " + delimitedData + ", " + deliminator + ")"));
        StringSplitterDecorator tokens = new StringSplitterDecorator(delimitedData, deliminator);
        double frequency = tokens.getDouble("frequency_mhz");
        double intensity = tokens.getDouble("intensity");
        String band = tokens.getNullString("band");
        return SourceDataFactory.getSourceData(frequency, intensity, band);
    }

    public static SourceData getSourceData(int lineNumber, String delimitedData, String regex) {
        return SourceDataFactory.getInstance().getSourceDataInstance(lineNumber, delimitedData, regex);
    }

    public SourceData getSourceDataInstance(int lineNumber, String delimitedData, String regex) {
        log.debug((Object)("Enter: getSourceDataInstance(" + lineNumber + ", " + delimitedData + ", " + regex + ")"));
        StringSplitterDecorator tokens = new StringSplitterDecorator(delimitedData, regex);
        double frequency = tokens.getDouble("frequency_mhz");
        double intensity = tokens.getDouble("intensity");
        String band = null;
        if (tokens.hasMoreTokens()) {
            band = tokens.getString("band");
        }
        return SourceDataFactory.getSourceData(frequency, intensity, band);
    }

    protected SourceDataBean getSourceDataBean() {
        return new SourceDataBean();
    }
}

