/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.sourcedata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.math.BigDecimal;
import org.apache.commons.io.IOUtils;
import org.ferris.astronomy.data.source.Source;
import org.ferris.astronomy.data.sourcedata.SourceData;
import org.ferris.astronomy.data.sourcedata.SourceDataFactory;
import org.ferris.astronomy.data.sourcedata.SourceDataList;
import org.ferris.astronomy.data.sourcedata.SourceDataServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.lang.Code;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.io.CanonicalFile;
import org.ferris.io.InputOutputException;

public class SourceDataServicesByFile
implements SourceDataServices {
    public SourceDataList findByFrequency(double freqMin, double freqMax, Source[] sources) throws AstronomyException {
        SourceDataList sourceDataList;
        Source source = this.getSource(sources);
        File dataFile = this.getFile(source.getId());
        FileInputStream fis = null;
        InputStreamReader isr = null;
        LineNumberReader rdr = null;
        try {
            fis = new FileInputStream(dataFile);
            isr = new InputStreamReader(fis);
            rdr = new LineNumberReader(isr);
            BigDecimal min = BigDecimalTools.getBigDecimal(freqMin);
            BigDecimal max = BigDecimalTools.getBigDecimal(freqMax);
            SourceDataList matches = new SourceDataList();
            String line = rdr.readLine();
            while (line != null) {
                if ((line = line.trim()).length() != 0 && !line.startsWith("#")) {
                    SourceData bean = this.getSourceData(rdr.getLineNumber(), line, dataFile);
                    BigDecimal freq = BigDecimalTools.getBigDecimal(bean.getFrequency().multiply(source.getFrequencyMultiplier()));
                    int c1 = freq.compareTo(min);
                    int c2 = freq.compareTo(max);
                    if (!(c1 != 0 && c1 != 1 || c2 != 0 && c2 != -1)) {
                        matches.add(bean);
                    }
                }
                line = rdr.readLine();
            }
            sourceDataList = matches;
        }
        catch (IOException e) {
            try {
                throw new AstronomyException(Code.ASTR000058, (Throwable)e, e.getMessage(), dataFile);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(rdr);
                IOUtils.closeQuietly(isr);
                IOUtils.closeQuietly((InputStream)fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)rdr);
        IOUtils.closeQuietly((Reader)isr);
        IOUtils.closeQuietly((InputStream)fis);
        return sourceDataList;
    }

    private SourceData getSourceData(int lineNumber, String line, File dataFile) {
        try {
            return SourceDataFactory.getSourceData(lineNumber, line, "[\\t ]++");
        }
        catch (Throwable t) {
            throw new AstronomyException(Code.ASTR000059, t, lineNumber, dataFile, t.getMessage(), line);
        }
    }

    private File getFile(String sourceId) throws InputOutputException {
        return CanonicalFile.fileInstance((File)new File(sourceId));
    }

    private Source getSource(Source[] sources) throws AstronomyException {
        if (sources == null) {
            throw new AstronomyException(Code.ASTR000056, new Object[0]);
        }
        if (sources.length != 1) {
            throw new AstronomyException(Code.ASTR000057, sources.length, 1);
        }
        return sources[0];
    }
}

