/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.sourcedata;

import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.source.Source;
import org.ferris.astronomy.data.sourcedata.SourceDataList;
import org.ferris.astronomy.data.sourcedata.SourceDataResponseHandler;
import org.ferris.astronomy.data.sourcedata.SourceDataServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.astronomy.net.runner.HttpRequestRunnerForLineListServices;

public class SourceDataServicesByPhp
implements SourceDataServices {
    private static String PAGE = "get.source.data.php";
    protected Logger log = Logger.getLogger(this.getClass());

    private final String getParameter(double d) {
        return BigDecimalTools.getBigDecimal(d).toPlainString();
    }

    private final String getParameter(Source[] sources) {
        StringBuilder sourceIdList = new StringBuilder("");
        for (int i = 0; i < sources.length; ++i) {
            if (i > 0) {
                sourceIdList.append(",");
            }
            sourceIdList.append(sources[i].getId());
        }
        return sourceIdList.toString();
    }

    public SourceDataList findByFrequency(double freqMin, double freqMax, Source[] sources) throws AstronomyException {
        this.log.info((Object)("Enter: findByFrequency() " + freqMin + "," + freqMax + "," + Arrays.toString(sources)));
        this.log.info((Object)"Creating runner <SourceData>");
        HttpRequestRunnerForLineListServices runner = new HttpRequestRunnerForLineListServices(PAGE);
        this.log.info((Object)"Building query");
        StringBuilder query = new StringBuilder();
        query.append(runner.getResource());
        query.append("?");
        query.append("minFreqMhz").append("=").append("?");
        query.append("&");
        query.append("maxFreqMhz").append("=").append("?");
        query.append("&");
        query.append("sourceIdList").append("=").append("?");
        this.log.info((Object)("Query: " + query.toString()));
        this.log.info((Object)"Setting query parameters");
        runner.addParameter(this.getParameter(freqMin));
        runner.addParameter(this.getParameter(freqMax));
        runner.addParameter(this.getParameter(sources));
        this.log.info((Object)"Running query");
        List list = runner.get(query.toString(), new SourceDataResponseHandler());
        this.log.info((Object)"Creating SourceDataList");
        SourceDataList retval = null;
        retval = new SourceDataList();
        retval.addAll(list);
        list.clear();
        this.log.info((Object)("Returning SourceDataList, size=" + retval.size()));
        return retval;
    }
}

