/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.sourcedata;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.ferris.astronomy.data.ServicesBySql;
import org.ferris.astronomy.data.source.Source;
import org.ferris.astronomy.data.sourcedata.SourceDataFactory;
import org.ferris.astronomy.data.sourcedata.SourceDataList;
import org.ferris.astronomy.data.sourcedata.SourceDataServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.lang.Code;
import org.ferris.sql.ConnectionFactory;
import org.ferris.sql.ConnectionTools;

public class SourceDataServicesBySql
extends ServicesBySql
implements SourceDataServices {
    public SourceDataServicesBySql(ConnectionFactory factory) {
        super(factory);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SourceDataList findByFrequency(double freqMin, double freqMax, Source[] sources) throws AstronomyException {
        SourceDataList sourceDataList;
        StringBuffer sp = new StringBuffer("select frequency_mhz, intensity from source_data ");
        sp.append(" where ");
        sp.append(" frequency_mhz between ").append(freqMin).append(" and ").append(freqMax);
        for (int i = 0; i < sources.length; ++i) {
            sp.append(" and ");
            sp.append(" sourcePtr=").append(sources[i].getId());
        }
        String sql = sp.toString();
        sp.setLength(0);
        sp = null;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            SourceDataList list = new SourceDataList();
            while (rs.next()) {
                list.add(SourceDataFactory.getSourceData(rs));
            }
            sourceDataList = list;
        }
        catch (AstronomyException e) {
            try {
                throw e;
                catch (Throwable t) {
                    throw new AstronomyException(Code.ASTR000052, t, sql);
                }
            }
            catch (Throwable throwable) {
                ConnectionTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        ConnectionTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return sourceDataList;
    }
}

