/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.specie;

import java.io.InputStream;
import java.util.List;
import org.ferris.astronomy.data.specie.Specie;
import org.ferris.astronomy.data.specie.SpecieFactory;
import org.ferris.astronomy.io.LineNumberReaderWithErrorChecking;
import org.ferris.astronomy.net.runner.HttpResponseHandlerForPlainText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SpecieResponseHandler
extends HttpResponseHandlerForPlainText<Specie> {
    SpecieResponseHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Specie> response(InputStream response) {
        List<Specie> retval = super.response(response);
        LineNumberReaderWithErrorChecking reader = this.getLineNumberReaderWithErrorChecking();
        try {
            String line = reader.getLine();
            while (line != null) {
                retval.add(SpecieFactory.getSpecie(line, line));
                line = reader.getLine();
            }
            List<Specie> list = retval;
            return list;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable ignore) {}
            }
        }
    }
}

