/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.specie;

import java.util.List;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.linelist.LineList;
import org.ferris.astronomy.data.specie.SpecieList;
import org.ferris.astronomy.data.specie.SpecieResponseHandler;
import org.ferris.astronomy.data.specie.SpecieServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.net.runner.HttpRequestRunnerForLineListServices;

public class SpecieServicesByPhp
implements SpecieServices {
    private static String PAGE = "get.species.php";
    protected Logger log = Logger.getLogger(this.getClass());

    public SpecieList findAll() throws AstronomyException {
        this.log.info((Object)"Enter: findAll()");
        this.log.info((Object)"Creating runner <Specie>");
        HttpRequestRunnerForLineListServices runner = new HttpRequestRunnerForLineListServices(PAGE);
        this.log.info((Object)"Building query");
        StringBuilder query = new StringBuilder();
        query.append(runner.getResource());
        this.log.info((Object)("Query: " + query.toString()));
        this.log.info((Object)"Setting query parameters");
        this.log.info((Object)"Running query");
        List list = runner.get(query.toString(), new SpecieResponseHandler());
        this.log.info((Object)"Creating SpecieList");
        SpecieList retval = null;
        retval = new SpecieList();
        retval.addAll(list);
        list.clear();
        this.log.info((Object)("Returning SpecieList, size=" + retval.size()));
        return retval;
    }

    public SpecieList findByLineList(LineList lineList) throws AstronomyException {
        this.log.info((Object)("Enter: findByLineList(" + lineList + ")"));
        this.log.info((Object)"Creating runner <Specie>");
        HttpRequestRunnerForLineListServices runner = new HttpRequestRunnerForLineListServices(PAGE);
        this.log.info((Object)"Building query");
        StringBuilder query = new StringBuilder();
        query.append(runner.getResource());
        query.append("?");
        query.append("linelist").append("=").append("?");
        this.log.info((Object)("Query: " + query.toString()));
        this.log.info((Object)"Setting query parameters");
        runner.addParameter(lineList.getName());
        this.log.info((Object)"Running query");
        List list = runner.get(query.toString(), new SpecieResponseHandler());
        this.log.info((Object)"Creating SpecieList");
        SpecieList retval = null;
        retval = new SpecieList();
        retval.addAll(list);
        list.clear();
        this.log.info((Object)("Returning SpecieList, size=" + retval.size()));
        return retval;
    }
}

