/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.specie;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.ferris.astronomy.data.ServicesBySql;
import org.ferris.astronomy.data.linelist.LineList;
import org.ferris.astronomy.data.specie.SpecieFactory;
import org.ferris.astronomy.data.specie.SpecieList;
import org.ferris.astronomy.data.specie.SpecieServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.lang.Code;
import org.ferris.sql.ConnectionFactory;
import org.ferris.sql.ConnectionTools;

public class SpecieServicesBySql
extends ServicesBySql
implements SpecieServices {
    public SpecieServicesBySql(ConnectionFactory factory) {
        super(factory);
    }

    private SpecieList buildList(ResultSet rs) throws SQLException {
        SpecieList list = new SpecieList();
        while (rs.next()) {
            list.add(SpecieFactory.getSpecie(rs));
        }
        return list;
    }

    public SpecieList findAll() throws AstronomyException {
        SpecieList specieList;
        String sql = "select distinct(molecule) id, molecule name from catalog order by molecule";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            specieList = this.buildList(rs);
        }
        catch (Throwable t) {
            try {
                throw new AstronomyException(Code.ASTR000051, t, sql);
            }
            catch (Throwable throwable) {
                ConnectionTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        ConnectionTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return specieList;
    }

    public SpecieList findByLineList(LineList lineList) throws AstronomyException {
        SpecieList specieList;
        String sql = "select distinct(molecule) id, molecule name from catalog where linelist=? order by molecule";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, lineList.getId());
            rs = stmt.executeQuery();
            specieList = this.buildList(rs);
        }
        catch (Throwable t) {
            try {
                throw new AstronomyException(Code.ASTR000051, t, sql);
            }
            catch (Throwable throwable) {
                ConnectionTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        ConnectionTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return specieList;
    }
}

