/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.splatalogue;

import java.math.BigDecimal;
import org.ferris.astronomy.data.intensity.IntensityStrategy;
import org.ferris.astronomy.data.linelist.LineList;
import org.ferris.astronomy.data.molecule.Molecule;
import org.ferris.astronomy.data.splatalogue.Splatalogue;
import org.ferris.lang.string.ToStringStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplatalogueBean
implements Splatalogue {
    private static final ToStringStrategy<Splatalogue> defaultToStringStrategy = new DefaultToStringStrategry();
    protected String id;
    protected BigDecimal frequency;
    protected BigDecimal eLower;
    protected BigDecimal eUpper;
    protected BigDecimal sij;
    protected BigDecimal qc;
    protected BigDecimal qe;
    protected ToStringStrategy<Splatalogue> toStringStrategy;
    protected LineList lineList;
    protected Molecule molecule;
    protected IntensityStrategy intensityStrategy;

    protected Splatalogue setELower(BigDecimal lower) {
        this.eLower = lower;
        return this;
    }

    protected Splatalogue setEUpper(BigDecimal upper) {
        this.eUpper = upper;
        return this;
    }

    protected Splatalogue setFrequency(BigDecimal frequency) {
        this.frequency = frequency;
        return this;
    }

    protected Splatalogue setId(String id) {
        this.id = id;
        return this;
    }

    protected Splatalogue setSij(BigDecimal sij) {
        this.sij = sij;
        return this;
    }

    protected Splatalogue setLineList(LineList lineList) {
        this.lineList = lineList;
        return this;
    }

    protected Splatalogue setMolecule(Molecule molecule) {
        this.molecule = molecule;
        return this;
    }

    protected Splatalogue setQc(BigDecimal qc) {
        this.qc = qc;
        return this;
    }

    protected Splatalogue setQe(BigDecimal qe) {
        this.qe = qe;
        return this;
    }

    public SplatalogueBean() {
        this.setToStringStrategy(defaultToStringStrategy);
    }

    @Override
    public ToStringStrategy<Splatalogue> getToStringStrategy() {
        return this.toStringStrategy;
    }

    @Override
    public Splatalogue setToStringStrategy(ToStringStrategy<Splatalogue> strategy) {
        this.toStringStrategy = strategy;
        return this;
    }

    @Override
    public String toString() {
        return this.toStringStrategy.toString((Object)this);
    }

    @Override
    public BigDecimal getELower() {
        return this.eLower;
    }

    @Override
    public BigDecimal getEUpper() {
        return this.eUpper;
    }

    @Override
    public BigDecimal getFrequency() {
        return this.frequency;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public BigDecimal getSij() {
        return this.sij;
    }

    @Override
    public BigDecimal getQc() {
        return this.qc;
    }

    @Override
    public BigDecimal getQe() {
        return this.qe;
    }

    @Override
    public LineList getLineList() {
        return this.lineList;
    }

    @Override
    public Molecule getMolecule() {
        return this.molecule;
    }

    @Override
    public BigDecimal getIntensity() {
        return this.getIntensityStrategy().getIntensity();
    }

    @Override
    public IntensityStrategy getIntensityStrategy() {
        return this.intensityStrategy;
    }

    @Override
    public Splatalogue setIntensityStrategy(IntensityStrategy is) {
        this.intensityStrategy = is;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultToStringStrategry
    implements ToStringStrategy<Splatalogue> {
        private DefaultToStringStrategry() {
        }

        public String toString(Splatalogue splat) {
            return "[SplatalogueBean id=" + splat.getId() + "]";
        }
    }
}

