/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.splatalogue;

import java.math.BigDecimal;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.linelist.LineList;
import org.ferris.astronomy.data.linelist.LineListFactory;
import org.ferris.astronomy.data.molecule.Molecule;
import org.ferris.astronomy.data.molecule.MoleculeFactory;
import org.ferris.astronomy.data.splatalogue.SplatalogueBean;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.dom.NodeAdaptor;

public class SplatalogueFactory {
    private static Logger log = Logger.getLogger(SplatalogueFactory.class);

    public static SplatalogueBean getSplatalogue(String id, BigDecimal frequency, BigDecimal eLower, BigDecimal eUpper, BigDecimal sij, BigDecimal qc, BigDecimal qe, LineList linelist, Molecule molecule) {
        log.debug((Object)("Enter: getSplatalogue(" + frequency + "," + eLower + "," + eUpper + "," + sij + "," + linelist + "," + molecule + ")"));
        SplatalogueBean bean = new SplatalogueBean();
        bean.setId(id);
        bean.setFrequency(frequency);
        bean.setELower(eLower);
        bean.setEUpper(eUpper);
        bean.setSij(sij);
        bean.setLineList(linelist);
        bean.setMolecule(molecule);
        bean.setQc(qc);
        bean.setQe(qe);
        return bean;
    }

    public static SplatalogueBean getSplatalogue(NodeAdaptor splatalogue) {
        log.debug((Object)("Enter: getSplatalogue(" + splatalogue + ")"));
        return SplatalogueFactory.getSplatalogue(splatalogue.getNodeAdaptor("id").getValue(), BigDecimalTools.getBigDecimal(splatalogue.getNodeAdaptor("ordered-frequency").getValue()), BigDecimalTools.getBigDecimalNullable(splatalogue.getNodeAdaptor("lower-state-energy-k").getValue()), BigDecimalTools.getBigDecimalNullable(splatalogue.getNodeAdaptor("upper-state-energy-k").getValue()), BigDecimalTools.getBigDecimalNullable(splatalogue.getNodeAdaptor("sij").getValue()), BigDecimalTools.getBigDecimalNullable(splatalogue.getNodeAdaptor("qc").getValue()), BigDecimalTools.getBigDecimalNullable(splatalogue.getNodeAdaptor("qe").getValue()), LineListFactory.getLineList(splatalogue.getNodeAdaptor("linelist")), MoleculeFactory.getMolecule(splatalogue.getNodeAdaptor("molecule")));
    }
}

