/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.data.splatalogue;

import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.ferris.astronomy.data.splatalogue.SplatalogueList;
import org.ferris.astronomy.data.splatalogue.SplatalogueResponseHandler;
import org.ferris.astronomy.data.splatalogue.SplatalogueServices;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.net.runner.HttpRequestRunnerSplatServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplatalogueServicesByPhp
implements SplatalogueServices {
    private static String PAGE = "get.splatalogue.php";
    protected Logger log = Logger.getLogger(this.getClass());

    @Override
    public SplatalogueList findByFrequency(double freqMin, double freqMax, List<String> speciesIds) throws AstronomyException {
        this.log.info((Object)("Enter: findByFrequency(" + freqMin + ", " + freqMax + ", " + speciesIds.toString() + ")"));
        this.log.info((Object)"Creating runner <Splatalogue>");
        HttpRequestRunnerSplatServices runner = new HttpRequestRunnerSplatServices(PAGE);
        this.log.info((Object)"Building query");
        StringBuilder query = new StringBuilder();
        query.append(runner.getResource());
        query.append("?");
        query.append("version").append("=").append("?");
        query.append("&");
        query.append("minFreqMhz").append("=").append("?");
        query.append("&");
        query.append("maxFreqMhz").append("=").append("?");
        Iterator<String> itr = speciesIds.iterator();
        while (itr.hasNext()) {
            query.append("&");
            query.append("speciesId[]").append("=").append("?");
            itr.next();
        }
        this.log.info((Object)("Query: " + query.toString()));
        this.log.info((Object)"Setting query parameters");
        runner.addParameter("2");
        runner.addParameter(String.valueOf(freqMin));
        runner.addParameter(String.valueOf(freqMax));
        for (String speciesId : speciesIds) {
            runner.addParameter(speciesId);
        }
        this.log.info((Object)"Running query");
        List list = runner.get(query.toString(), new SplatalogueResponseHandler());
        this.log.info((Object)"Creating SplatalogueList");
        SplatalogueList retval = null;
        retval = new SplatalogueList();
        retval.addAll(list);
        list.clear();
        this.log.info((Object)("Returning SplatalogueList, size=" + retval.size()));
        return retval;
    }
}

