/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.dom;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.lang.Code;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class DocumentFactory {
    public static Document getDocument(InputStream is) throws AstronomyException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(false);
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(is);
            if (document == null) {
                throw new AstronomyException(Code.ASTR000042, new Object[0]);
            }
        }
        catch (Throwable t) {
            if (t instanceof SAXParseException) {
                SAXParseException sax = (SAXParseException)t;
                if (sax.getMessage().contains("1 of 1-byte UTF-8")) {
                    String err = sax.toString() + " Line number: " + sax.getLineNumber() + " Column number: " + sax.getColumnNumber() + " Public ID: " + sax.getPublicId() + " System ID: " + sax.getSystemId();
                    throw new AstronomyException(Code.ASTR000044, t, err);
                }
            }
            throw new AstronomyException(Code.ASTR000043, t, new Object[0]);
        }
        return document;
    }
}

