/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.io;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import org.ferris.astronomy.lang.AstronomyException;
import org.ferris.astronomy.lang.Code;

public class LineNumberReaderWithErrorChecking
extends LineNumberReader {
    public LineNumberReaderWithErrorChecking(Reader reader) {
        super(reader);
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("Use the getLine() method instead!");
    }

    public String getLine() throws AstronomyException {
        String line = null;
        try {
            line = super.readLine();
            if (line == null) {
                return line;
            }
            if (line.startsWith("ERROR:")) {
                throw new AstronomyException(Code.ASTR000054, this.getLineNumber(), line);
            }
            if (line.trim().length() == 0) {
                return this.getLine();
            }
            return line;
        }
        catch (IOException e) {
            throw new AstronomyException(Code.ASTR000055, (Throwable)e, this.getLineNumber(), line);
        }
    }
}

