/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.astronomy.util.split;

import java.math.BigDecimal;
import java.util.NoSuchElementException;
import org.ferris.astronomy.math.BigDecimalTools;
import org.ferris.util.split.StringSplitter;

public class StringSplitterDecorator {
    private StringSplitter ss;

    public StringSplitterDecorator(String stringToSplit, char deliminator) {
        this.ss = new StringSplitter(stringToSplit, String.valueOf(deliminator));
    }

    public StringSplitterDecorator(String stringToSplit, String regex) {
        this.ss = new StringSplitter(stringToSplit, regex);
    }

    public String nextToken() {
        return this.ss.nextElement();
    }

    public int countTokens() {
        int cnt = this.ss.countElements();
        if (cnt == 0) {
            throw new NoSuchElementException("There are no more tokens to count.");
        }
        return cnt;
    }

    public String getString(String columnName) {
        if (this.ss.hasMoreElements()) {
            String next = this.ss.nextElement();
            if (next == null || next.length() == 0) {
                throw new NoSuchElementException("The column \"" + columnName + "\" is empty.");
            }
            return next;
        }
        throw new NoSuchElementException("The column \"" + columnName + "\" does not exist.");
    }

    public String getNullString(String columnName) {
        if (this.ss.hasMoreElements()) {
            String next = this.ss.nextElement();
            if (next == null || next.length() == 0) {
                next = null;
            }
            return next;
        }
        return null;
    }

    public double getDouble(String columnName) {
        if (this.ss.hasMoreElements()) {
            return BigDecimalTools.getBigDecimal(this.ss.nextElement()).doubleValue();
        }
        throw new NoSuchElementException("The column \"" + columnName + "\" does not exist.");
    }

    public BigDecimal getBigDecimal(String columnName) {
        if (this.ss.hasMoreElements()) {
            String next = this.ss.nextElement();
            if (next == null || next.length() == 0) {
                throw new NoSuchElementException("The column \"" + columnName + "\" is empty.");
            }
            return BigDecimalTools.getBigDecimal(next);
        }
        throw new NoSuchElementException("The column \"" + columnName + "\" does not exist.");
    }

    public BigDecimal getNullBigDecimal(String columnName) {
        if (this.ss.hasMoreElements()) {
            String next = this.ss.nextElement();
            if (next == null || next.length() == 0) {
                return null;
            }
            return BigDecimalTools.getBigDecimal(next);
        }
        return null;
    }

    public boolean hasMoreTokens() {
        return this.ss.hasMoreElements();
    }
}

