/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.bible.servlet;

import com.simplerss.dataobject.Channel;
import com.simplerss.dataobject.Guid;
import com.simplerss.dataobject.Item;
import com.simplerss.dataobject.Source;
import com.simplerss.helper.RSSBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ferris.bible.servlet.Version;
import org.ferris.bible.store.Store;
import org.ferris.bible.store.StoreFactory;
import org.ferris.bible.store.StoreItem;

public class DailyBibleReadingRssServlet
extends HttpServlet {
    private static final long serialVersionUID = -6911931194683267534L;
    private static final String MyEmail = "mjremijan@yahoo.com (Mike Remijan)";
    private static final String ManagingEditor = "mjremijan@yahoo.com (Mike Remijan)";
    private static final String WebMaster = "mjremijan@yahoo.com (Mike Remijan)";
    private static final String Author = "mjremijan@yahoo.com (Mike Remijan)";
    private static final String Category = "Bible New Living Translation";
    private static final String Title = "Daily Bible Reading";
    private static URL Link = null;
    private static URL Source = null;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.go((OutputStream)baos);
        baos.flush();
        resp.setContentType("application/rss+xml");
        resp.setContentLength(baos.size());
        resp.getOutputStream().write(baos.toByteArray());
        baos.close();
        resp.getOutputStream().flush();
    }

    public void go(OutputStream os) throws IOException {
        Store store = StoreFactory.getStore();
        List items = store.getAll();
        if (items.isEmpty()) {
            return;
        }
        Calendar now = Calendar.getInstance();
        Channel c = new Channel();
        c.setCategory(Category);
        c.setCloud(null);
        c.setCopyright("Copyright, BibleGateway.com");
        c.setDescription("Read the Bible this year");
        c.setDocs(new URL("http://cyber.law.harvard.edu/rss/rss.html"));
        c.setGenerator("Ferris Bible JMCE DailyBibleReadingRssServlet v" + new Version().getVersion());
        c.setImage(null);
        c.setItem(this.getItems(items));
        c.setLanguage("en-us");
        c.setLastBuildDate(now);
        c.setLink(Link);
        c.setManagingEditor("mjremijan@yahoo.com (Mike Remijan)");
        c.setPubDate(this.getLatestReadingDay(items));
        c.setTextInput(null);
        c.setTitle(Title);
        c.setTtl(60);
        c.setWebMaster("mjremijan@yahoo.com (Mike Remijan)");
        os.write(RSSBuilder.getRSSDocument((Channel)c).getBytes("utf-8"));
    }

    private Item[] getItems(List<StoreItem> storeItems) {
        Item[] items = new Item[storeItems.size()];
        int itemsIdx = 0;
        for (StoreItem storeItem : storeItems) {
            Item item = new Item();
            item.setAuthor("mjremijan@yahoo.com (Mike Remijan)");
            item.setCategory(Category);
            item.setDescription(storeItem.getReading());
            item.setGuid(this.getGuid(storeItem));
            item.setPubDate(this.getCalendar(storeItem));
            item.setSource(this.getSource(storeItem));
            item.setTitle(this.getTitle(storeItem));
            items[itemsIdx] = item;
            ++itemsIdx;
        }
        return items;
    }

    private Guid getGuid(StoreItem storeItem) {
        Guid guid = new Guid();
        guid.setPermaLink(false);
        try {
            guid.setUrl(new URL(Source.toString() + "#" + this.yyyyMMdd(storeItem)));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return guid;
    }

    private Source getSource(StoreItem storeItem) {
        Source s = new Source();
        s.setTitle(this.getTitle(storeItem));
        s.setUrl(Source);
        return s;
    }

    private String getTitle(StoreItem storeItem) {
        return "Daily Bible Reading for " + new SimpleDateFormat("MM/dd").format(this.getCalendar(storeItem).getTime());
    }

    private Calendar getLatestReadingDay(List<StoreItem> items) {
        TreeSet<String> set = new TreeSet<String>();
        for (StoreItem item : items) {
            set.add(this.yyyyMMdd(item));
        }
        return this.getCalendar((String)set.last());
    }

    private String yyyyMMdd(StoreItem storeItem) {
        return storeItem.getYear() + (storeItem.getMonth() < 10 ? "0" : "") + storeItem.getMonth() + (storeItem.getDay() < 10 ? "0" : "") + storeItem.getDay();
    }

    private Calendar getCalendar(String yyyyMMdd) {
        GregorianCalendar gc = new GregorianCalendar();
        try {
            gc.setTime(new SimpleDateFormat("yyyyMMdd").parse(yyyyMMdd));
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
        gc.clear(10);
        gc.clear(12);
        gc.clear(13);
        gc.clear(14);
        return gc;
    }

    private Calendar getCalendar(StoreItem storeItem) {
        return this.getCalendar(this.yyyyMMdd(storeItem));
    }

    static {
        String s = "http://ferris.dnsalias.net:8888/bible/rss/";
        String t = s + "DailyBibleReading.xml";
        try {
            Link = new URL(s);
            Source = new URL(t);
        }
        catch (MalformedURLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

