/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.flickrj.fascade;

import com.aetrion.flickr.Flickr;
import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.REST;
import com.aetrion.flickr.RequestContext;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.auth.Auth;
import com.aetrion.flickr.auth.AuthInterface;
import com.aetrion.flickr.auth.Permission;
import com.aetrion.flickr.photosets.Photosets;
import com.aetrion.flickr.photosets.PhotosetsInterface;
import com.aetrion.flickr.uploader.UploadMetaData;
import com.aetrion.flickr.uploader.Uploader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.ferris.flickrj.model.License;
import org.ferris.flickrj.security.FlickrApiCredentials;
import org.xml.sax.SAXException;

public class FlickrJFascade {
    private Logger log = Logger.getLogger(this.getClass());
    private FlickrApiCredentials credentials;
    private Flickr flickr;
    private String frob;
    private Auth auth;

    public FlickrApiCredentials getFlickrApiCredentials() {
        return this.credentials;
    }

    public FlickrJFascade(FlickrApiCredentials credentials) {
        this.log.info((Object)("CONSTRUCTOR: FlickrJHelper(" + credentials + ")"));
        if (credentials == null) {
            throw new RuntimeException("Parameter credentials is null");
        }
        this.credentials = credentials;
    }

    Flickr getFlickr() {
        if (this.flickr == null) {
            try {
                this.flickr = new Flickr(this.getFlickrApiCredentials().getApiKey(), this.getFlickrApiCredentials().getSecret(), (Transport)new REST());
                Flickr.debugStream = false;
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return this.flickr;
    }

    RequestContext getRequestContext() {
        return RequestContext.getRequestContext();
    }

    public AuthInterface getAuthInterface() {
        return this.getFlickr().getAuthInterface();
    }

    public String getFrob() {
        if (this.frob == null) {
            try {
                this.frob = this.getAuthInterface().getFrob();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (FlickrException e) {
                throw new RuntimeException(e);
            }
            System.out.println("frob = " + this.frob);
        }
        return this.frob;
    }

    public Auth getAuth() {
        if (this.auth == null) {
            try {
                if (this.getFlickrApiCredentials().getAuthenticationToken() != null) {
                    this.auth = this.getAuthInterface().checkToken(this.getFlickrApiCredentials().getAuthenticationToken());
                    this.auth.setToken(this.getFlickrApiCredentials().getAuthenticationToken());
                } else {
                    this.auth = this.getAuthInterface().getToken(this.getFrob());
                    this.getFlickr().setAuth(this.auth);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
            catch (FlickrException e) {
                throw new RuntimeException(e);
            }
        }
        return this.auth;
    }

    public Photosets getPhotosets() {
        try {
            return this.getPhotosetsInterface().getList(this.getAuth().getUser().getId());
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    public PhotosetsInterface getPhotosetsInterface() {
        return this.getFlickr().getPhotosetsInterface();
    }

    public String uploadPhoto(File file, String title, String description, boolean isPublicFlag, boolean isFamilyFlag, boolean isFriendFlag, License license) {
        this.log.info((Object)"Get Auth");
        Auth auth = this.getAuth();
        if (auth.getPermission() != Permission.WRITE) {
            this.log.info((Object)"Set permissions write");
            auth.setPermission(Permission.WRITE);
        } else {
            this.log.info((Object)"Permission already write.");
        }
        this.log.info((Object)"Set auth in RequestContext");
        this.getRequestContext().setAuth(auth);
        this.log.info((Object)"Set auth in Flickr");
        this.getFlickr().setAuth(auth);
        UploadMetaData uploadMetaData = new UploadMetaData();
        uploadMetaData.setAsync(false);
        uploadMetaData.setContentType("1");
        uploadMetaData.setSafetyLevel("1");
        uploadMetaData.setTitle(title);
        uploadMetaData.setDescription(description);
        uploadMetaData.setPublicFlag(isPublicFlag);
        uploadMetaData.setFamilyFlag(isFamilyFlag);
        uploadMetaData.setFriendFlag(isFriendFlag);
        this.log.info((Object)("Upload File: " + file));
        String photoId = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            Uploader uploader = new Uploader(this.getFlickrApiCredentials().getApiKey(), this.getFlickrApiCredentials().getSecret());
            photoId = uploader.upload((InputStream)fileInputStream, uploadMetaData);
            if (photoId == null) {
                throw new Exception("The uploader returned NULL for the photoId.");
            }
            fileInputStream.close();
            fileInputStream = null;
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                    fileInputStream = null;
                }
                catch (Throwable ignore) {}
            }
        }
        try {
            this.getFlickr().getLicensesInterface().setLicense(photoId, license.getId());
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
        return photoId;
    }
}

