/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.flickrj.model;

import com.aetrion.flickr.auth.Permission;
import com.aetrion.flickr.people.User;
import com.aetrion.flickr.photosets.Photoset;
import com.aetrion.flickr.photosets.Photosets;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.ferris.flickrj.fascade.FlickrJFascade;
import org.ferris.flickrj.model.FlickrSet;
import org.ferris.flickrj.model.FlickrSets;
import org.ferris.flickrj.model.FlickrUser;
import org.ferris.flickrj.security.FlickrApiCredentials;

public class FlickrPhotostream {
    private Logger log = Logger.getLogger(this.getClass());
    private FlickrJFascade fascade;
    private FlickrUser flickrUser;
    private URL writePermissionAuthenticationUrl;
    private URL readPermissionAuthenticationUrl;

    private FlickrJFascade getFascade() {
        return this.fascade;
    }

    private FlickrPhotostream setFascade(FlickrJFascade fascade) {
        this.fascade = fascade;
        return this;
    }

    public FlickrPhotostream(FlickrApiCredentials credentials) {
        this.setFascade(new FlickrJFascade(credentials));
    }

    public URL getWritePermissionAuthenticationUrl() {
        this.log.info((Object)"ENTER: getWritePermissionAuthenticationUrl()");
        if (this.writePermissionAuthenticationUrl == null) {
            this.log.info((Object)"Create writePermissionAuthenticationUrl for the first time.");
            try {
                this.writePermissionAuthenticationUrl = this.getFascade().getAuthInterface().buildAuthenticationUrl(Permission.WRITE, this.getFascade().getFrob());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            this.log.info((Object)("writePermissionAuthenticationUrl = " + this.writePermissionAuthenticationUrl));
        }
        return this.writePermissionAuthenticationUrl;
    }

    public URL getReadPermissionAuthenticationUrl() {
        this.log.info((Object)"ENTER: getReadPermissionAuthenticationUrl()");
        if (this.readPermissionAuthenticationUrl == null) {
            this.log.info((Object)"Create readPermissionAuthenticationUrl for the first time.");
            try {
                this.readPermissionAuthenticationUrl = this.getFascade().getAuthInterface().buildAuthenticationUrl(Permission.READ, this.getFascade().getFrob());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            this.log.info((Object)("readPermissionAuthenticationUrl = " + this.readPermissionAuthenticationUrl));
        }
        return this.readPermissionAuthenticationUrl;
    }

    public String getAuthenticationToken() {
        return this.getFascade().getAuth().getToken();
    }

    public FlickrUser getUser() {
        if (this.flickrUser == null) {
            User u = this.getFascade().getAuth().getUser();
            this.flickrUser = new FlickrUser.Builder().setId(u.getId()).setRealName(u.getRealName()).setUserName(u.getUsername()).build();
        }
        return this.flickrUser;
    }

    public FlickrSets getSets() {
        FlickrSets sets = new FlickrSets();
        Photosets ps = this.getFascade().getPhotosets();
        if (ps.getPhotosets() != null) {
            for (Photoset p : ps.getPhotosets()) {
                sets.add(new FlickrSet.Builder(this.getFascade()).setDescription(p.getDescription()).setTitle(p.getTitle()).setId(p.getId()).build());
            }
        }
        return sets;
    }
}

