/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.flickrj.model;

import java.io.File;
import org.ferris.flickrj.fascade.FlickrJFascade;
import org.ferris.flickrj.model.License;

public class FlickrSet {
    private FlickrJFascade fascade;
    private String id;
    private String description;
    private String title;

    private FlickrJFascade getFascade() {
        return this.fascade;
    }

    private FlickrSet(FlickrJFascade fascade) {
        this.fascade = fascade;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTitle() {
        return this.title;
    }

    private void setId(String id) {
        this.id = id;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    private void setTitle(String title) {
        this.title = title;
    }

    public void uploadPhoto(File file, String title, String description, boolean isPublicFlag, boolean isFamilyFlag, boolean isFriendFlag, License license) {
        this.addPhoto(this.getFascade().uploadPhoto(file, title, description, isPublicFlag, isFamilyFlag, isFriendFlag, license));
    }

    public void addPhoto(String photoId) {
        try {
            this.getFascade().getPhotosetsInterface().addPhoto(this.getId(), photoId);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    public static class Builder {
        private FlickrSet set;

        public Builder(FlickrJFascade fascade) {
            this.set = new FlickrSet(fascade);
        }

        public Builder setId(String id) {
            this.set.setId(id);
            return this;
        }

        public Builder setDescription(String id) {
            this.set.setDescription(id);
            return this;
        }

        public Builder setTitle(String id) {
            this.set.setTitle(id);
            return this;
        }

        public FlickrSet build() {
            return this.set;
        }
    }
}

