/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.ferris.io.FileSplitter;
import org.ferris.util.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSplitterAsText
implements FileSplitter {
    private File sourceFile;
    private File destinationDirectory;
    private String destinationFileBaseName;
    private String destinationFileExtension;
    private long destinationFileSizeInBytes;
    private Sequence<String> sequence;
    private Set<File> parts;

    public FileSplitterAsText(File sourceFile, File destinationDirectory, String destinationFileBaseName, String destinationFileExtension, long destinationFileSizeInBytes, Sequence<String> sequence) throws IOException {
        this.setSourceFile(sourceFile);
        this.setDestinationDirectory(destinationDirectory);
        this.setDestinationFileBaseName(destinationFileBaseName);
        this.setDestinationFileExtension(destinationFileExtension);
        this.setDestinationFileSizeInBytes(destinationFileSizeInBytes);
        this.setSequence(sequence);
        this.setParts();
    }

    @Override
    public File getDestinationDirectory() {
        return this.destinationDirectory;
    }

    private void setDestinationDirectory(File directory) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setDestinationDirectory() says," + " the destinationDirectory parameter is null.");
        }
        this.destinationDirectory = directory.getCanonicalFile();
        if (!this.destinationDirectory.exists()) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setDestinationDirectory() says," + " the destinationDirectory" + " \"" + this.destinationDirectory + "\"" + " does not exist.");
        }
    }

    @Override
    public String getDestinationFileBaseName() {
        return this.destinationFileBaseName;
    }

    private void setDestinationFileBaseName(String clown) {
        this.destinationFileBaseName = clown;
        if (this.destinationFileBaseName == null) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setDestinationFileBaseName() says," + " the destinationFileBaseName" + " parameter is null.");
        }
        this.destinationFileBaseName = StringUtils.trimToNull((String)this.destinationFileBaseName);
        if (this.destinationFileBaseName == null) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setDestinationFileBaseName() says," + " the destinationFileBaseName" + " \"" + clown + "\"" + " trimmed to null.");
        }
    }

    @Override
    public String getDestinationFileExtention() {
        return this.destinationFileExtension;
    }

    private void setDestinationFileExtension(String clown) {
        this.destinationFileExtension = clown;
        if (this.destinationFileExtension == null) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setDestinationFileExtension() says," + " the destinationFileExtension" + " parameter is null.");
        }
        this.destinationFileExtension = StringUtils.trimToNull((String)this.destinationFileExtension);
        if (this.destinationFileExtension == null) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setDestinationFileExtension() says," + " the destinationFileExtension" + " \"" + clown + "\"" + " trimmed to null.");
        }
    }

    @Override
    public Sequence<String> getSequence() {
        return this.sequence;
    }

    private void setSequence(Sequence<String> clown) {
        if (clown == null) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setSequence() says," + " the sequence parameter is null.");
        }
        this.sequence = clown;
    }

    private void setParts() {
        this.parts = new TreeSet<File>();
    }

    private void addPart(File file) {
        this.getParts().add(file);
    }

    @Override
    public Set<File> getParts() {
        return this.parts;
    }

    @Override
    public File getSourceFile() {
        return this.sourceFile;
    }

    private void setSourceFile(File clown) throws IOException {
        if (clown == null) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setSourceFile() says," + " the sourceFile parameter is null.");
        }
        this.sourceFile = clown.getCanonicalFile();
        if (!this.sourceFile.exists()) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setSourceFile() says," + " the sourceFile " + " \"" + this.sourceFile + "\"" + " does not exist.");
        }
    }

    @Override
    public long getDestinationFileSizeInBytes() {
        return this.destinationFileSizeInBytes;
    }

    private void setDestinationFileSizeInBytes(long clown) {
        if (clown == 0L) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setDestinationFileSizeInBytes() says," + " the destinationFileSizeInBytes == 0");
        }
        if (clown < 0L) {
            throw new IllegalArgumentException("Method " + this.getClass() + ".setDestinationFileSizeInBytes() says," + " destinationFileSizeInBytes = \"" + clown + "\"" + " which is less than 0.");
        }
        this.destinationFileSizeInBytes = clown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void split() throws IOException {
        if (this.getSourceFile().length() <= this.getDestinationFileSizeInBytes()) {
            FileUtils.copyFile((File)this.getSourceFile(), (File)this.getDestinationFileForNextPart());
            return;
        }
        LineIterator itr = FileUtils.lineIterator((File)this.getSourceFile());
        OutputStream stream = null;
        try {
            byte[] nl = IOUtils.LINE_SEPARATOR.getBytes();
            long byteCount = 0L;
            stream = this.getDestinationStreamForNextPart();
            while (itr.hasNext()) {
                byte[] bytes = itr.nextLine().getBytes();
                if ((byteCount += (long)(bytes.length + nl.length)) > this.getDestinationFileSizeInBytes()) {
                    IOUtils.closeQuietly((OutputStream)stream);
                    stream = this.getDestinationStreamForNextPart();
                    byteCount = bytes.length + nl.length;
                }
                stream.write(bytes);
                stream.write(nl);
            }
        }
        catch (Throwable throwable) {
            LineIterator.closeQuietly((LineIterator)itr);
            IOUtils.closeQuietly(stream);
            throw throwable;
        }
        LineIterator.closeQuietly((LineIterator)itr);
        IOUtils.closeQuietly((OutputStream)stream);
    }

    @Override
    public File getDestinationFileForNextPart() {
        StringBuffer sp = new StringBuffer();
        sp.append(this.getDestinationFileBaseName());
        sp.append((String)this.getSequence().getNext());
        sp.append(".");
        sp.append(this.getDestinationFileExtention());
        File f = new File(this.getDestinationDirectory(), sp.toString());
        this.addPart(f);
        return f;
    }

    private OutputStream getDestinationStreamForNextPart() throws IOException {
        return new FileOutputStream(this.getDestinationFileForNextPart());
    }
}

