/*
 * Decompiled with CFR 0.152.
 */
package org.ferris.io;

import java.io.File;
import org.apache.log4j.Logger;
import org.ferris.io.CanonicalFile;
import org.ferris.io.FileFilterForDirectories;
import org.ferris.io.FileFilterForFiles;
import org.ferris.io.InputOutputException;
import org.ferris.io.InputOutputExceptionCode;
import org.ferris.util.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveFilesIntoSubDirectories {
    private Logger log = Logger.getLogger(this.getClass());
    private File directory;
    private int fileCountInSubDirectory;
    private File[] files;
    private File[] subDirectories;
    private Sequence<String> sequence;
    private int moved;

    private MoveFilesIntoSubDirectories setSequence(Sequence<String> _sequence) {
        if (_sequence == null) {
            throw new InputOutputException(InputOutputExceptionCode.IO000019, new Object[0]);
        }
        this.sequence = _sequence;
        return this;
    }

    private Sequence<String> getSequence() {
        return this.sequence;
    }

    private MoveFilesIntoSubDirectories setDirectory(File _directory) {
        this.directory = CanonicalFile.directoryInstance(_directory);
        this.log.info((Object)("Move files in directory \"" + this.directory + "\""));
        return this;
    }

    private File getDirectory() {
        return this.directory;
    }

    private MoveFilesIntoSubDirectories setFileCountInSubDirectory(int _fileCountInSubDirectory) {
        if (_fileCountInSubDirectory <= 0) {
            throw new InputOutputException(InputOutputExceptionCode.IO000017, _fileCountInSubDirectory);
        }
        this.fileCountInSubDirectory = _fileCountInSubDirectory;
        this.log.info((Object)("File count per subdirectory: " + this.fileCountInSubDirectory));
        return this;
    }

    private MoveFilesIntoSubDirectories setFiles() {
        this.files = this.getDirectory().listFiles(new FileFilterForFiles());
        if (this.files == null) {
            this.files = new File[0];
        }
        this.log.info((Object)("Number of files to move: " + this.files.length));
        if (this.log.isDebugEnabled()) {
            for (int i = 0; i < this.files.length; ++i) {
                this.log.debug((Object)(i + ") " + this.files[i]));
            }
        }
        return this;
    }

    private File[] getFiles() {
        return this.files;
    }

    private int getNumberOfSubDirectoriesNeeded() {
        double a = this.getNumberOfFilesToMove();
        double b = this.getFileCountInSubDirectory();
        int c = (int)Math.ceil(a / b);
        this.log.info((Object)("Number of subdirectories needed: ceil(" + a + "/" + b + ")=" + c));
        return c;
    }

    private MoveFilesIntoSubDirectories setSubDirectories() {
        if (this.getNumberOfSubDirectoriesNeeded() == 0) {
            this.subDirectories = new File[0];
        } else {
            this.subDirectories = new File[this.getNumberOfSubDirectoriesNeeded()];
            int ilen = this.subDirectories.length;
            for (int i = 0; i < ilen; ++i) {
                this.subDirectories[i] = new File(this.getDirectory(), (String)this.getSequence().getNext());
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)(i + ") " + this.subDirectories[i]));
            }
        }
        File[] existingSubDirectories = this.getDirectory().listFiles(new FileFilterForDirectories());
        if (existingSubDirectories == null) {
            existingSubDirectories = new File[]{};
        }
        int ilen = this.subDirectories.length;
        for (int i = 0; i < ilen; ++i) {
            int klen = existingSubDirectories.length;
            for (int k = 0; k < klen; ++k) {
                if (!existingSubDirectories[k].getName().equals(this.subDirectories[i].getName())) continue;
                throw new InputOutputException(InputOutputExceptionCode.IO000018, this.subDirectories[i]);
            }
        }
        return this;
    }

    public MoveFilesIntoSubDirectories(File _directory, int _fileCountInSubDirectory, Sequence<String> _sequence) {
        this.setSequence(_sequence);
        this.setDirectory(_directory);
        this.setFileCountInSubDirectory(_fileCountInSubDirectory);
        this.setFiles();
        this.setSubDirectories();
    }

    public File[] getSubDirectories() {
        return this.subDirectories;
    }

    public int getFileCountInSubDirectory() {
        return this.fileCountInSubDirectory;
    }

    public int getNumberOfFilesToMove() {
        return this.getFiles().length;
    }

    public int getNumberOfFilesMoved() {
        return this.moved;
    }

    public int incrementNumberOfFilesMoved() {
        ++this.moved;
        return this.moved;
    }

    public MoveFilesIntoSubDirectories move() {
        int fidx = 0;
        for (int sdidx = 0; sdidx < this.getSubDirectories().length; ++sdidx) {
            File subDirectory = this.getSubDirectories()[sdidx];
            subDirectory.mkdir();
            for (int moved = 0; moved < this.getFileCountInSubDirectory() && fidx < this.getNumberOfFilesToMove(); ++moved, ++fidx) {
                this.log.debug((Object)("Moving \"" + this.getFiles()[fidx].getName() + "\" to \"/" + subDirectory.getName() + "\""));
                boolean rename = this.getFiles()[fidx].renameTo(new File(subDirectory, this.getFiles()[fidx].getName()));
                if (rename) {
                    this.incrementNumberOfFilesMoved();
                    continue;
                }
                this.log.debug((Object)("FAILED Moving \"" + this.getFiles()[fidx].getName() + "\" to \"/" + subDirectory.getName() + "\""));
            }
            this.log.debug((Object)("Moved " + this.getNumberOfFilesMoved() + " of " + this.getNumberOfFilesToMove() + " files."));
        }
        return this;
    }
}

